/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.world.entity.GhostEntity;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;

public class WitherGhostEntity
extends GhostEntity {
    public WitherGhostEntity(EntityType<? extends WitherGhostEntity> type, Level worldIn) {
        super((EntityType<? extends GhostEntity>)type, worldIn);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return GhostEntity.createAttributes().m_22268_(Attributes.f_22276_, 20.0);
    }

    @Override
    protected boolean shouldBurnInDay() {
        return false;
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        if (!super.m_7327_(entityIn)) {
            return false;
        }
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200));
        }
        return true;
    }

    @Override
    protected void m_6851_(DifficultyInstance difficulty) {
        float f = this.m_21187_().nextFloat();
        float f2 = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        } else {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 4 && i == 1 && this.m_21187_().nextFloat() < 0.5f) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42429_));
            }
        }
    }

    public boolean m_7301_(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.m_19544_() == MobEffects.f_19615_) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(potioneffectIn);
    }
}

