/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.projectile;

import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.registry.ModParticleTypes;
import com.github.mechalopa.hmag.world.entity.LichEntity;
import com.github.mechalopa.hmag.world.entity.projectile.ModDamagingProjectileEntity;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagicBulletEntity
extends ModDamagingProjectileEntity {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(MagicBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> EFFECT_LEVEL = SynchedEntityData.m_135353_(MagicBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.m_135353_(MagicBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private IntOpenHashSet piercingIgnoreEntityIds;

    public MagicBulletEntity(EntityType<? extends MagicBulletEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public MagicBulletEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), shooter, accelX, accelY, accelZ, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MagicBulletEntity(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGIC_BULLET.get()), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(EFFECT_LEVEL, (Object)1);
        this.f_19804_.m_135372_(PIERCE_LEVEL, (Object)0);
    }

    protected float m_6884_() {
        switch (this.getVariant()) {
            case 1: {
                return 0.87f;
            }
            case 2: {
                return 0.98f;
            }
        }
        return 0.9f;
    }

    @Override
    protected void tick2() {
        if (this.getVariant() == 2) {
            if (!(this.f_19853_.f_46443_ || this.f_19797_ < 60 && this.m_37282_() != null)) {
                this.m_146870_();
            }
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.NEMESIS_FLAME.get(), this.m_20208_(0.5), this.m_20227_(this.f_19796_.nextDouble() * 0.5), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            super.tick2();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercingIgnoreEntityIds.size() < this.getPierceLevel() + 1) {
                this.piercingIgnoreEntityIds.add(entity.m_142049_());
            }
        }
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            Entity entity1 = this.m_37282_();
            float damage = this.getDamage();
            if (entity1 != null && entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                if (this.getVariant() == 0 && livingentity instanceof LichEntity && entity instanceof Vex && livingentity.m_7307_(entity)) {
                    damage *= 5.0f;
                }
                if ((flag = entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)livingentity), damage)) && entity.m_6084_()) {
                    this.m_19970_(livingentity, entity);
                }
            } else {
                flag = entity.m_6469_(DamageSource.f_19319_, damage);
            }
            if (flag && entity instanceof LivingEntity && this.getEffectLevel() > 0) {
                int i = 0;
                switch (this.getVariant()) {
                    case 0: {
                        if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                            i = 7;
                        } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                            i = 15;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20 * i, 0));
                        break;
                    }
                    case 1: {
                        if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                            i = 5;
                        } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                            i = 10;
                        }
                        if (i <= 0) break;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20 * i, 0));
                        break;
                    }
                    case 2: {
                        i = (this.getEffectLevel() * 2 + 4) * 20;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, i, 1));
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i, 1));
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19599_, i, 1));
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, i, 1));
                        if (!(vec3.m_82556_() > 0.0)) break;
                        ((LivingEntity)entity).m_147240_((double)(1.0f * ((float)this.getEffectLevel() / 12.0f) + 0.1f), -vec3.f_82479_, -vec3.f_82481_);
                    }
                }
            }
            this.f_19853_.m_7605_((Entity)this, (byte)3);
        }
    }

    protected boolean m_5603_(Entity entityIn) {
        return super.m_5603_(entityIn) && this.m_37282_() != null && !this.m_37282_().equals((Object)entityIn) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(entityIn.m_142049_()));
    }

    @Override
    protected void onHitServer(HitResult result) {
        if (result.m_6662_() != HitResult.Type.ENTITY || this.getPierceLevel() <= 0 || this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
            this.m_146870_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DATA_VARIANT_ID.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.getVariant() == 2) {
            return super.m_6972_(pose).m_20388_(1.6f);
        }
        return super.m_6972_(pose);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3 && this.getVariant() == 2) {
            for (int i = 0; i < 12; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ModParticleTypes.NEMESIS_FLAME.get(), this.m_20208_(1.75), this.m_20227_(this.f_19796_.nextDouble() * 1.75), this.m_20262_(1.75), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    public void setVariant(int typeIn) {
        if (typeIn < 0 || typeIn >= 3) {
            typeIn = 0;
        }
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)typeIn);
    }

    public void setPierceLevel(byte amount) {
        this.f_19804_.m_135381_(PIERCE_LEVEL, (Object)amount);
    }

    public byte getPierceLevel() {
        return (Byte)this.f_19804_.m_135370_(PIERCE_LEVEL);
    }

    public void setEffectLevel(byte amount) {
        this.f_19804_.m_135381_(EFFECT_LEVEL, (Object)amount);
    }

    public byte getEffectLevel() {
        return (Byte)this.f_19804_.m_135370_(EFFECT_LEVEL);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128344_("PierceLevel", this.getPierceLevel());
        compound.m_128344_("EffectLevel", this.getEffectLevel());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setPierceLevel(compound.m_128445_("PierceLevel"));
        this.setEffectLevel(compound.m_128445_("EffectLevel"));
    }

    protected ParticleOptions m_5967_() {
        switch (this.getVariant()) {
            case 1: {
                return ParticleTypes.f_123755_;
            }
            case 2: {
                return ParticleTypes.f_123762_;
            }
        }
        return ParticleTypes.f_123799_;
    }
}

