/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.projectile;

import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.world.entity.projectile.ModDamagingProjectileEntity;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class MagmaBulletEntity
extends ModDamagingProjectileEntity {
    private static final EntityDataAccessor<Integer> LIFE_TIME = SynchedEntityData.m_135353_(MagmaBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int life = 25;

    public MagmaBulletEntity(EntityType<? extends MagmaBulletEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public MagmaBulletEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGMA_BULLET.get()), shooter, accelX, accelY, accelZ, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MagmaBulletEntity(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends ModDamagingProjectileEntity>)((EntityType)ModEntityTypes.MAGMA_BULLET.get()), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIFE_TIME, (Object)25);
    }

    protected float m_6884_() {
        return 0.85f;
    }

    @Override
    protected void tick2() {
        super.tick2();
        if (this.life > 0) {
            this.life = this.m_20071_() ? Math.max(this.life - 3, 0) : --this.life;
        }
        if (this.life <= 0) {
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
            }
            this.f_36813_ *= 0.97;
            this.f_36814_ *= 0.97;
            this.f_36815_ *= 0.97;
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.f_19853_.f_46443_ && !(entity = result.m_82443_()).m_5825_()) {
            Entity entity1 = this.m_37282_();
            int i = entity.m_20094_();
            entity.m_20254_(5);
            boolean flag = entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)entity1).m_19383_(), this.getDamage());
            if (!flag) {
                entity.m_7311_(i);
            } else if (entity1 != null && entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    @Override
    protected void onHitServer(HitResult result) {
        boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
        this.f_19853_.m_46518_((Entity)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.75f, flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        this.f_19853_.m_7605_((Entity)this, (byte)3);
        super.onHitServer(result);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            BlockParticleOption particleoptions = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50450_.m_49966_()).setPos(this.m_142538_());
            for (int i = 0; i < 16; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (!this.m_20072_()) {
                for (int j = 0; j < 8; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void setLifeTime(int amount) {
        this.f_19804_.m_135381_(LIFE_TIME, (Object)amount);
        this.life = amount;
    }

    public int getLifeTime() {
        return (Integer)this.f_19804_.m_135370_(LIFE_TIME);
    }

    public int getLife() {
        return this.life;
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (LIFE_TIME.equals(data)) {
            this.life = this.getLifeTime();
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("Life", (short)this.getLife());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLifeTime(compound.m_128448_("Life"));
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123762_;
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.15f;
    }
}

