/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.projectile;

import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.world.entity.projectile.ModProjectileItemEntity;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PoisonSeedEntity
extends ModProjectileItemEntity {
    public PoisonSeedEntity(EntityType<? extends PoisonSeedEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public PoisonSeedEntity(Level worldIn, LivingEntity throwerIn) {
        super((EntityType<? extends ModProjectileItemEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), throwerIn, worldIn);
    }

    public PoisonSeedEntity(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends ModProjectileItemEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), x, y, z, worldIn);
    }

    protected Item m_7881_() {
        return Items.f_42733_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.nextFloat() - 0.5) * 0.08, ((double)this.f_19796_.nextFloat() - 0.5) * 0.08, ((double)this.f_19796_.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitServer(HitResult result) {
        AABB aabb = this.m_142469_().m_82377_(4.0, 2.0, 4.0);
        List list = this.f_19853_.m_45976_(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                double d0;
                if (!livingEntity.m_5801_() || !((d0 = this.m_20280_((Entity)livingEntity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_() == livingEntity) {
                    d1 = 1.0;
                }
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 140;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 300;
                }
                if ((i = (int)(d1 * (double)i + 0.5)) <= 20) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, i, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, i, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, i, 0));
            }
        }
        this.f_19853_.m_46796_(2002, this.m_142538_(), MobEffects.f_19614_.m_19484_());
        this.f_19853_.m_7605_((Entity)this, (byte)3);
        super.onHitServer(result);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), this.getDamage());
    }
}

