/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item;

import com.github.mechalopa.hmag.registry.ModItems;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum ModArmorMaterial implements ArmorMaterial
{
    ANCIENT("hmag:ancient", 34, new int[]{3, 6, 8, 3}, 15, SoundEvents.f_11677_, 2.5f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ANCIENT_STONE.get()})),
    NECROTIC_CHAIN("hmag:necrotic_chainmail", 19, new int[]{2, 5, 6, 2}, 15, SoundEvents.f_11672_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NECROFIBER.get()}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private ModArmorMaterial(String nameIn, int durabilityMultiplierIn, int[] slotProtectionsIn, int enchantmentIn, SoundEvent sound, float toughnessIn, float knockbackResistanceIn, Supplier<Ingredient> repairItems) {
        this.name = nameIn;
        this.durabilityMultiplier = durabilityMultiplierIn;
        this.slotProtections = slotProtectionsIn;
        this.enchantmentValue = enchantmentIn;
        this.sound = sound;
        this.toughness = toughnessIn;
        this.knockbackResistance = knockbackResistanceIn;
        this.repairIngredient = new LazyLoadedValue(repairItems);
    }

    public int m_7366_(EquipmentSlot slot) {
        return HEALTH_PER_SLOT[slot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot slot) {
        return this.slotProtections[slot.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

