/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;

public class ModSwordItem
extends SwordItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int maxDamage;
    private final int enchantability;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ModSwordItem(Tier tier, Item.Properties builderIn) {
        this(tier, 3.0f, -2.4f, builderIn);
    }

    public ModSwordItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        this(tier, attackDamageIn, attackSpeedIn, tier.m_6609_(), tier.m_6601_(), builderIn);
    }

    public ModSwordItem(Tier tier, float attackDamageIn, float attackSpeedIn, int maxDamageIn, int enchantabilityIn, Item.Properties builderIn) {
        super(tier, Mth.m_14143_((float)attackDamageIn), attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        this.attackSpeed = attackSpeedIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        this.maxDamage = maxDamageIn;
        this.enchantability = enchantabilityIn;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    public float m_43299_() {
        return this.attackDamage;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDamage;
    }

    public int m_6473_() {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return this.m_43314_() == Tiers.WOOD ? 200 : super.getBurnTime(stack, recipeType);
    }
}

