/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item.crafting;

import com.github.mechalopa.hmag.registry.ModRecipes;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.item.EnchantmentUpgradeItem;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EnchantmentUpgradeRecipe
extends UpgradeRecipe {
    private final ResourceLocation recipeId;

    public EnchantmentUpgradeRecipe(ResourceLocation recipeId) {
        super(recipeId, Ingredient.f_43901_, Ingredient.f_43901_, ItemStack.f_41583_);
        this.recipeId = recipeId;
    }

    public boolean m_5818_(Container inv, Level level) {
        List<EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp> eups;
        ItemStack stack = inv.m_8020_(0);
        ItemStack stack1 = inv.m_8020_(1);
        if (!stack.m_41619_() && stack.m_41720_() != null && stack.m_41720_() != Items.f_42690_ && !stack1.m_41619_() && stack1.m_41720_() != null && stack1.m_41720_() instanceof EnchantmentUpgradeItem && stack1.m_204117_(ModTags.ENCHANTMENT_UPGRADE_ITEMS) && !stack.m_204117_(ModTags.ENCHANTMENT_UPGRADEABLE_BLACKLIST) && !(eups = ((EnchantmentUpgradeItem)stack1.m_41720_()).getEnchantmentUpgradeProps()).isEmpty()) {
            for (EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp eup : eups) {
                Enchantment enchantment;
                if (eup == null || (enchantment = eup.getEnchantment()) == null || !EnchantmentUpgradeRecipe.checkEnchantableItem(stack, enchantment, eup.getMinLevel(), eup.getMaxLevel())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkEnchantableItem(ItemStack stackIn, Enchantment enchantmentIn, int min, int max) {
        int i;
        return !stackIn.m_41619_() && enchantmentIn.m_6081_(stackIn) && ((i = EnchantmentHelper.m_44843_((Enchantment)enchantmentIn, (ItemStack)stackIn)) == 0 && min == 0 && max >= 0 ? EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)stackIn).keySet(), (Enchantment)enchantmentIn) : i >= min && i <= max);
    }

    public ItemStack m_5874_(Container inv) {
        List<EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp> eups;
        ItemStack stack = inv.m_8020_(1);
        if (stack.m_41720_() instanceof EnchantmentUpgradeItem && !(eups = ((EnchantmentUpgradeItem)stack.m_41720_()).getEnchantmentUpgradeProps()).isEmpty()) {
            for (EnchantmentUpgradeItem.Properties.EnchantmentUpgradeProp eup : eups) {
                ItemStack stack1;
                Enchantment enchantment;
                if (eup == null || (enchantment = eup.getEnchantment()) == null || !EnchantmentUpgradeRecipe.checkEnchantableItem(stack1 = inv.m_8020_(0), enchantment, eup.getMinLevel(), eup.getMaxLevel())) continue;
                ItemStack stack2 = stack1.m_41777_();
                if (stack1.m_41793_()) {
                    stack2.m_41749_("Enchantments");
                    stack2.m_41749_("StoredEnchantments");
                    int j = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack1);
                    Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack1).entrySet().stream().filter(p -> p.getKey() != enchantment).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    map.put(enchantment, j + 1);
                    EnchantmentHelper.m_44865_(map, (ItemStack)stack2);
                    stack2.m_41742_(0);
                    for (int k = 0; k < map.size(); ++k) {
                        stack2.m_41742_(AnvilMenu.m_39025_((int)stack1.m_41610_()));
                    }
                } else {
                    EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)enchantment, (Object)1), (ItemStack)stack2);
                }
                return stack2;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ENCHANTMENT_UPGRADE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<EnchantmentUpgradeRecipe> {
        public EnchantmentUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new EnchantmentUpgradeRecipe(this.getRegistryName());
        }

        @Nonnull
        public EnchantmentUpgradeRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new EnchantmentUpgradeRecipe(this.getRegistryName());
        }

        public void toNetwork(FriendlyByteBuf buffer, EnchantmentUpgradeRecipe recipe) {
        }
    }
}

