/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.item.crafting;

import com.github.mechalopa.hmag.registry.ModRecipes;
import com.github.mechalopa.hmag.util.ModTags;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SuspiciousStewUpgradeRecipe
extends CustomRecipe {
    public static final String UPGRADED_KEY = "hmag.upgraded";

    public SuspiciousStewUpgradeRecipe(ResourceLocation recipeId) {
        super(recipeId);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean flag = false;
        boolean flag1 = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42718_) && stack.m_41782_() && !stack.m_41783_().m_128471_(UPGRADED_KEY) && !flag) {
                flag = true;
                continue;
            }
            if (!stack.m_204117_(ModTags.SUSPICIOUS_STEW_UPGRADE_ITEMS) || flag1) {
                return false;
            }
            flag1 = true;
        }
        return flag && flag1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack stack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack1 = inv.m_8020_(i);
            if (stack1.m_41619_() || !stack1.m_150930_(Items.f_42718_)) continue;
            stack = stack1.m_41777_();
            break;
        }
        if (!stack.m_41619_()) {
            CompoundTag compoundtag = stack.m_41784_();
            compoundtag.m_128379_(UPGRADED_KEY, true);
            if (compoundtag.m_128441_("Effects")) {
                ListTag listtag = compoundtag.m_128437_("Effects", 10);
                ItemStack stack2 = stack.m_41777_();
                CompoundTag compoundtag1 = stack2.m_41784_();
                compoundtag1.m_128473_("Effects");
                ListTag listtag1 = compoundtag1.m_128437_("Effects", 9);
                for (int i = 0; i < listtag.size(); ++i) {
                    int j = 0;
                    CompoundTag compoundtag2 = listtag.m_128728_(i);
                    if (compoundtag2.m_128441_("EffectDuration")) {
                        j = compoundtag2.m_128451_("EffectDuration");
                    }
                    byte b0 = compoundtag2.m_128445_("EffectId");
                    MobEffect mobeffect = MobEffect.m_19453_((int)b0);
                    String name = compoundtag2.m_128461_("forge:effect_id");
                    if (!Strings.isNullOrEmpty((String)name)) {
                        try {
                            mobeffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(name));
                        }
                        catch (ResourceLocationException resourceLocationException) {
                            // empty catch block
                        }
                    }
                    if (mobeffect == null || j <= 0) continue;
                    CompoundTag compoundtag3 = new CompoundTag();
                    compoundtag3.m_128344_("EffectId", b0);
                    compoundtag3.m_128359_("forge:effect_id", mobeffect.getRegistryName().toString());
                    compoundtag3.m_128405_("EffectDuration", mobeffect.m_8093_() ? j + 5 : j * 5);
                    listtag1.add((Object)compoundtag3);
                }
                if (!listtag1.isEmpty()) {
                    compoundtag1.m_128365_("Effects", (Tag)listtag1);
                    return stack2;
                }
            }
        }
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SUSPICIOUS_STEW_UPGRADE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SuspiciousStewUpgradeRecipe> {
        public SuspiciousStewUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new SuspiciousStewUpgradeRecipe(this.getRegistryName());
        }

        @Nonnull
        public SuspiciousStewUpgradeRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new SuspiciousStewUpgradeRecipe(this.getRegistryName());
        }

        public void toNetwork(FriendlyByteBuf buffer, SuspiciousStewUpgradeRecipe recipe) {
        }
    }
}

