/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.level.storage.loot.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public class AdditionalEntityLootModifier
extends LootModifier {
    private static final Gson GSON = Deserializers.m_78799_().create();
    private final LootItemFunction[] functions;
    private final Item addition;

    public AdditionalEntityLootModifier(LootItemCondition[] conditionsIn, LootItemFunction[] functions, Item addition) {
        super(conditionsIn);
        this.functions = functions;
        this.addition = addition;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.addition != null) {
            ItemStack stack = this.addition.m_7968_();
            for (LootItemFunction function : this.functions) {
                stack = (ItemStack)function.apply((Object)stack, (Object)context);
            }
            generatedLoot.add(stack);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AdditionalEntityLootModifier> {
        public AdditionalEntityLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            LootItemFunction[] functions = object.has("functions") ? (LootItemFunction[])GSON.fromJson(object.get("functions"), LootItemFunction[].class) : new LootItemFunction[]{};
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"addition")));
            return new AdditionalEntityLootModifier(conditionsIn, functions, addition);
        }

        public JsonObject write(AdditionalEntityLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            if (!ArrayUtils.isEmpty((Object[])instance.functions)) {
                json.add("functions", GSON.toJsonTree((Object)instance.functions));
            }
            json.addProperty("addition", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition).toString());
            return json;
        }
    }
}

