/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.level.storage.loot.modifiers;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ReplaceLootModifier
extends LootModifier {
    private final Item original;
    private final Item replacement;

    public ReplaceLootModifier(LootItemCondition[] conditionsIn, Item original, Item replacement) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.original == null || this.replacement == null) {
            return generatedLoot;
        }
        return generatedLoot.stream().map(stack -> {
            if (stack.m_41720_() == this.original) {
                return new ItemStack((ItemLike)this.replacement, stack.m_41613_());
            }
            return stack;
        }).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ReplaceLootModifier> {
        public ReplaceLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            Item original = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"original")));
            Item replacement = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"replacement")));
            return new ReplaceLootModifier(conditionsIn, original, replacement);
        }

        public JsonObject write(ReplaceLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("original", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.original).toString());
            json.addProperty("replacement", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.replacement).toString());
            return json;
        }
    }
}

