/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;
import xyz.apex.forge.infusedfoods.init.IFRegistry;

@Mod(value="infusedfoods")
public final class InfusedFoods {
    public static final String ID = "infusedfoods";

    public InfusedFoods() {
        IFRegistry.bootstrap();
        EventBusHelper.addListener(LivingEntityUseItemEvent.Finish.class, this::onItemUseFinish);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> new Client());
    }

    private void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = event.getResultStack();
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        if (InfusedFoods.isValidFood(stack)) {
            List effects = PotionUtils.func_185190_b((ItemStack)stack);
            for (EffectInstance effectInstance : effects) {
                Effect effect = effectInstance.func_188419_a();
                if (effect.func_76403_b()) {
                    effect.func_180793_a((Entity)entity, (Entity)entity, entity, effectInstance.func_76458_c(), 1.0);
                    continue;
                }
                if (entity.func_70644_a(effect)) {
                    entity.func_195063_d(effect);
                }
                entity.func_195064_c(effectInstance);
            }
        }
    }

    public static boolean isValidFood(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_222117_E();
    }

    public static void appendPotionEffectTooltips(@Nullable Effect effect, int amplifier, int duration, List<ITextComponent> tooltip) {
        if (effect != null) {
            TranslationTextComponent potionName = new TranslationTextComponent(effect.func_76393_a());
            if (amplifier > 0) {
                potionName = new TranslationTextComponent("potion.withAmplifier", new Object[]{potionName, new TranslationTextComponent("potion.potency." + amplifier)});
            }
            if (duration > 20) {
                int i = MathHelper.func_76141_d((float)duration);
                String durationFormat = StringUtils.func_76337_a((int)i);
                potionName = new TranslationTextComponent("potion.withDuration", new Object[]{potionName, durationFormat});
            }
            tooltip.add((ITextComponent)potionName.func_240699_a_(effect.func_220303_e().func_220306_a()));
            Map attributeModifiers = effect.func_111186_k();
            if (!attributeModifiers.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
                tooltip.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
                attributeModifiers.forEach((attribute, attributeModifier) -> {
                    AttributeModifier mod = attributeModifier;
                    AttributeModifier mod1 = new AttributeModifier(mod.func_111166_b(), effect.func_111183_a(amplifier, mod), mod.func_220375_c());
                    double d0 = mod1.func_111164_d();
                    AttributeModifier.Operation operation = mod1.func_220375_c();
                    double d1 = operation != AttributeModifier.Operation.MULTIPLY_BASE && operation != AttributeModifier.Operation.MULTIPLY_TOTAL ? d0 : d0 * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    } else if (d0 < 0.0) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    }
                });
            }
        }
    }

    public static void appendPotionEffectTooltips(ItemStack stack, List<ITextComponent> tooltip) {
        CompoundNBT apexTag;
        CompoundNBT stackTag = stack.func_77978_p();
        if (stackTag != null && stackTag.func_150297_b("ApexData", 10) && (apexTag = stackTag.func_74775_l("ApexData")).func_150297_b("InfusionFluid", 10)) {
            CompoundNBT fluidTag = apexTag.func_74775_l("InfusionFluid");
            ResourceLocation effectRegistryName = new ResourceLocation(fluidTag.func_74779_i("Effect"));
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectRegistryName);
            int effectDuration = fluidTag.func_74762_e("Duration");
            int effectAmplifier = fluidTag.func_74762_e("Amplifier");
            InfusedFoods.appendPotionEffectTooltips(effect, effectAmplifier, effectDuration, tooltip);
        }
    }

    private static final class Client {
        private Client() {
            EventBusHelper.addListener(ItemTooltipEvent.class, this::onItemTooltip);
        }

        private void onItemTooltip(ItemTooltipEvent event) {
            List effects;
            ItemStack stack = event.getItemStack();
            List tooltip = event.getToolTip();
            if (InfusedFoods.isValidFood(stack) && !(effects = PotionUtils.func_185190_b((ItemStack)stack)).isEmpty()) {
                PotionUtils.func_185182_a((ItemStack)stack, (List)tooltip, (float)1.0f);
            }
        }
    }
}

