/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.revamp.block.BaseBlock;
import xyz.apex.forge.infusedfoods.InfusedFoods;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.container.InfusionStationContainer;
import xyz.apex.forge.infusedfoods.init.IFElements;
import xyz.apex.java.utility.nullness.NonnullConsumer;

public final class InfusionStationBlock
extends BaseBlock.WithContainer<InfusionStationBlockEntity, InfusionStationContainer> {
    public static final VoxelShape SHAPE = VoxelShaper.or((VoxelShape[])new VoxelShape[]{InfusionStationBlock.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0), InfusionStationBlock.func_208617_a((double)13.0, (double)0.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0)});
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal((VoxelShape)SHAPE, (Direction)Direction.NORTH);

    public InfusionStationBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING_4_WAY, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void registerProperties(NonnullConsumer<Property<?>> consumer) {
        consumer.accept((Object)FACING_4_WAY);
        consumer.accept((Object)WATERLOGGED);
    }

    public void func_180655_c(BlockState blockState, World level, BlockPos pos, Random rng) {
        if (blockState.func_235901_b_((Property)WATERLOGGED) && !((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            Direction facing = blockState.func_235903_d_((Property)FACING_4_WAY).orElse(Direction.NORTH).func_176746_e();
            double x = (double)pos.func_177958_n() + 0.4 + (double)rng.nextFloat() * 0.2 + (double)facing.func_82601_c() * 0.4;
            double y = (double)pos.func_177956_o() + 0.7 + (double)rng.nextFloat() * 0.3;
            double z = (double)pos.func_177952_p() + 0.4 + (double)rng.nextFloat() * 0.2 + (double)facing.func_82599_e() * 0.4;
            level.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void func_180633_a(World level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(level, pos, blockState, placer, stack);
        InfusionStationBlockEntity blockEntity = (InfusionStationBlockEntity)this.getBlockEntity((IBlockReader)level, pos);
        CompoundNBT apexTag = stack.func_179543_a("ApexData");
        if (blockEntity != null && apexTag != null) {
            blockEntity.deserializeData(apexTag);
        }
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader level, BlockPos pos, ISelectionContext ctx) {
        if (blockState.func_235901_b_((Property)FACING_4_WAY)) {
            Direction facing = (Direction)blockState.func_177229_b((Property)FACING_4_WAY);
            return SHAPER.get(facing);
        }
        return VoxelShapes.func_197868_b();
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader level, BlockPos pos, PathType pathType) {
        return false;
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader level, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) == false;
    }

    protected TileEntityType<InfusionStationBlockEntity> getBlockEntityType() {
        return IFElements.INFUSION_STATION_BLOCK_ENTITY.asBlockEntityType();
    }

    protected ContainerType<InfusionStationContainer> getContainerType() {
        return IFElements.INFUSION_STATION_CONTAINER.asContainerType();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, level, tooltip, flag);
        InfusedFoods.appendPotionEffectTooltips(stack, tooltip);
    }
}

