/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.block.entity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.apex.forge.apexcore.revamp.block.entity.InventoryBlockEntity;
import xyz.apex.forge.apexcore.revamp.net.packet.SyncContainerPacket;

public final class InfusionStationBlockEntity
extends InventoryBlockEntity
implements ITickableTileEntity {
    public static final String NBT_INFUSION_TIME = "InfusionTime";
    public static final String NBT_BLAZE_FUEL = "BlazeFuel";
    public static final String NBT_INFUSION_FLUID = "InfusionFluid";
    public static final String NBT_EFFECT = "Effect";
    public static final String NBT_AMOUNT = "Amount";
    public static final String NBT_DURATION = "Duration";
    public static final String NBT_AMPLIFIER = "Amplifier";
    public static final int SLOT_COUNT = 5;
    public static final int SLOT_POTION = 0;
    public static final int SLOT_BLAZE = 1;
    public static final int SLOT_FOOD = 2;
    public static final int SLOT_RESULT = 3;
    public static final int SLOT_BOTTLE = 4;
    public static final int INFUSION_TIME = 400;
    private int infuseTime = 0;
    private int blazeFuel = 0;
    @Nullable
    private Effect effect;
    private int effectAmount;
    private int effectDuration;
    private int effectAmplifier;

    public InfusionStationBlockEntity(TileEntityType<? extends InfusionStationBlockEntity> blockEntityType) {
        super(blockEntityType, 5);
    }

    @Nullable
    public Effect getEffect() {
        return this.effect;
    }

    public int getEffectAmount() {
        return this.effectAmount;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public int getInfuseTime() {
        return this.infuseTime;
    }

    public int getBlazeFuel() {
        return this.blazeFuel;
    }

    public CompoundNBT serializeData() {
        CompoundNBT tagCompound = super.serializeData();
        if (this.infuseTime > 0) {
            tagCompound.func_74768_a(NBT_INFUSION_TIME, this.infuseTime);
        }
        if (this.blazeFuel > 0) {
            tagCompound.func_74768_a(NBT_BLAZE_FUEL, this.blazeFuel);
        }
        if (this.effect != null) {
            CompoundNBT fluidTag = new CompoundNBT();
            String effectRegistryName = Objects.requireNonNull(this.effect.getRegistryName()).toString();
            fluidTag.func_74778_a(NBT_EFFECT, effectRegistryName);
            fluidTag.func_74768_a(NBT_AMOUNT, this.effectAmount);
            fluidTag.func_74768_a(NBT_DURATION, this.effectDuration);
            fluidTag.func_74768_a(NBT_AMPLIFIER, this.effectAmplifier);
            tagCompound.func_218657_a(NBT_INFUSION_FLUID, (INBT)fluidTag);
        }
        return tagCompound;
    }

    public void deserializeData(CompoundNBT tagCompound) {
        if (tagCompound.func_150297_b(NBT_INFUSION_TIME, 99)) {
            this.infuseTime = tagCompound.func_74762_e(NBT_INFUSION_TIME);
        }
        if (tagCompound.func_150297_b(NBT_BLAZE_FUEL, 99)) {
            this.blazeFuel = tagCompound.func_74762_e(NBT_BLAZE_FUEL);
        }
        if (tagCompound.func_150297_b(NBT_INFUSION_FLUID, 10)) {
            CompoundNBT fluidTag = tagCompound.func_74775_l(NBT_INFUSION_FLUID);
            ResourceLocation effectRegistryName = new ResourceLocation(fluidTag.func_74779_i(NBT_EFFECT));
            this.effect = (Effect)ForgeRegistries.POTIONS.getValue(effectRegistryName);
            this.effectAmount = fluidTag.func_74762_e(NBT_AMOUNT);
            this.effectDuration = fluidTag.func_74762_e(NBT_DURATION);
            this.effectAmplifier = fluidTag.func_74762_e(NBT_AMPLIFIER);
        }
        super.deserializeData(tagCompound);
    }

    public void writeContainerSyncData(PacketBuffer buffer) {
        boolean flag = this.effect != null;
        buffer.writeBoolean(flag);
        if (flag) {
            buffer.writeRegistryId((IForgeRegistryEntry)this.effect);
        }
        buffer.writeInt(this.effectAmount);
        buffer.writeInt(this.effectAmplifier);
        buffer.writeInt(this.effectDuration);
        buffer.writeInt(this.infuseTime);
        buffer.writeInt(this.blazeFuel);
    }

    public void readContainerSyncData(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.effect = (Effect)buffer.readRegistryId();
        }
        this.effectAmount = buffer.readInt();
        this.effectAmplifier = buffer.readInt();
        this.effectDuration = buffer.readInt();
        this.infuseTime = buffer.readInt();
        this.blazeFuel = buffer.readInt();
    }

    private boolean canInfuse() {
        if (this.effect == null || this.effectAmount < 0) {
            return false;
        }
        ItemStack food = this.itemHandler.getStackInSlot(2);
        if (food.func_190926_b()) {
            return false;
        }
        if (!PotionUtils.func_185190_b((ItemStack)food).isEmpty()) {
            return false;
        }
        ItemStack result = this.itemHandler.getStackInSlot(3);
        if (result.func_190926_b()) {
            return true;
        }
        if (!ItemStack.func_179545_c((ItemStack)result, (ItemStack)food)) {
            return false;
        }
        List resultEffects = PotionUtils.func_185190_b((ItemStack)result);
        if (resultEffects.size() == 1) {
            EffectInstance effectInstance = (EffectInstance)resultEffects.get(0);
            if (!Objects.equals(this.effect, effectInstance.func_188419_a())) {
                return false;
            }
            if (this.effectDuration != effectInstance.func_76459_b()) {
                return false;
            }
            if (this.effectAmplifier != effectInstance.func_76458_c()) {
                return false;
            }
        }
        return result.func_190916_E() + 1 < food.func_77976_d();
    }

    public void func_73660_a() {
        Potion potion;
        List effects;
        if (this.field_145850_b == null) {
            return;
        }
        ItemStack potionStack = this.itemHandler.getStackInSlot(0);
        ItemStack foodStack = this.itemHandler.getStackInSlot(2);
        ItemStack blazeStack = this.itemHandler.getStackInSlot(1);
        ItemStack resultStack = this.itemHandler.getStackInSlot(3);
        ItemStack bottleStack = this.itemHandler.getStackInSlot(4);
        boolean changed = false;
        if (this.blazeFuel <= 0 && !blazeStack.func_190926_b()) {
            this.blazeFuel = 20;
            blazeStack.func_190918_g(1);
            changed = true;
        }
        if (this.infuseTime > 0 && !this.canInfuse()) {
            this.infuseTime = 0;
            changed = true;
        }
        if (this.effect != null && this.effectAmount > 0) {
            if (this.canInfuse() && this.blazeFuel > 0) {
                if (this.infuseTime == 0) {
                    --this.blazeFuel;
                    this.infuseTime = 400;
                    changed = true;
                } else {
                    --this.infuseTime;
                    if (this.infuseTime == 0) {
                        if (resultStack.func_190926_b()) {
                            ItemStack foodToInfuse = foodStack.func_77979_a(1).func_77946_l();
                            foodToInfuse.func_190920_e(1);
                            PotionUtils.func_185184_a((ItemStack)foodToInfuse, Collections.singletonList(new EffectInstance(this.effect, this.effectDuration, this.effectAmplifier)));
                            this.itemHandler.setStackInSlot(3, foodToInfuse);
                        } else {
                            foodStack.func_190918_g(1);
                            resultStack.func_190917_f(1);
                        }
                        --this.effectAmount;
                    }
                    changed = true;
                }
            }
        } else if (!potionStack.func_190926_b() && (effects = (potion = PotionUtils.func_185191_c((ItemStack)potionStack)).func_185170_a()).size() == 1) {
            EffectInstance effectInstance = (EffectInstance)effects.get(0);
            this.effect = effectInstance.func_188419_a();
            this.effectAmplifier = effectInstance.func_76458_c();
            this.effectDuration = effectInstance.func_76459_b();
            this.effectAmount = 5;
            this.itemHandler.setStackInSlot(0, ItemStack.field_190927_a);
            if (bottleStack.func_190926_b()) {
                this.itemHandler.setStackInSlot(4, Items.field_151069_bo.func_190903_i());
            } else {
                bottleStack.func_190917_f(1);
            }
            this.infuseTime = 0;
            changed = true;
        }
        if (changed) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        SyncContainerPacket.sendToClient((InventoryBlockEntity)this);
    }

    public static int getColor(@Nullable Effect effect, int amplifier) {
        if (effect != null) {
            int l = amplifier + 1;
            if (l == 0) {
                return 0;
            }
            int k = effect.func_76401_j();
            float f = (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            float f1 = (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            float f2 = (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            f = f / (float)l * 255.0f;
            f1 = f1 / (float)l * 255.0f;
            f2 = f2 / (float)l * 255.0f;
            return (int)f << 16 | (int)f1 << 8 | (int)f2;
        }
        return 3694022;
    }
}

