/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.items.IItemHandler;
import xyz.apex.forge.infusedfoods.block.InfusionStationBlock;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.client.renderer.model.InfusionStationModel;
import xyz.apex.forge.infusedfoods.init.IFElements;

public final class InfusionStationBlockEntityRenderer
extends TileEntityRenderer<InfusionStationBlockEntity> {
    private final InfusionStationModel model = new InfusionStationModel(RenderType::func_228644_e_);

    public InfusionStationBlockEntityRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(InfusionStationBlockEntity blockEntity, float partialTick, MatrixStack pose, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IItemHandler inventory = blockEntity.getItemHandler();
        Effect effect = blockEntity.getEffect();
        int effectAmount = blockEntity.getEffectAmount();
        boolean hasBottle = !inventory.getStackInSlot(4).func_190926_b();
        boolean hasPotion = !inventory.getStackInSlot(0).func_190926_b();
        boolean hasFluid = effect != null && effectAmount > 0;
        boolean hasFood = !inventory.getStackInSlot(2).func_190926_b();
        int color = InfusionStationBlockEntity.getColor(effect, blockEntity.getEffectAmplifier());
        this.model.setUpForRender(hasPotion, hasBottle, hasFluid, hasFood, color);
        pose.func_227860_a_();
        BlockState blockState = blockEntity.func_195044_w();
        Direction facing = (Direction)blockState.func_177229_b((Property)InfusionStationBlock.FACING_4_WAY);
        pose.func_227861_a_(0.5, 0.5, 0.5);
        pose.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
        pose.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        pose.func_227861_a_(0.0, -1.0, 0.0);
        RenderType renderType = RenderType.func_228642_d_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE);
        IVertexBuilder modelBuffer = buffer.getBuffer(renderType);
        this.model.func_225598_a_(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.func_227860_a_();
        pose.func_227861_a_(0.0, 1.0, 0.0);
        renderType = RenderType.func_228642_d_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE_TINT);
        modelBuffer = buffer.getBuffer(renderType);
        this.model.renderToBufferTint(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f, true);
        pose.func_227865_b_();
        pose.func_227865_b_();
    }

    public void renderForGUI(ItemStack stack, InfusionStationBlockEntity blockEntity, float partialTick, MatrixStack pose, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay, ItemCameraTransforms.TransformType transformType) {
        if (transformType == ItemCameraTransforms.TransformType.NONE) {
            return;
        }
        boolean hasPotion = false;
        int potionColor = 7474959;
        Effect effect = blockEntity.getEffect();
        int effectAmount = blockEntity.getEffectAmount();
        if (effect != null && effectAmount > 0) {
            hasPotion = true;
            potionColor = InfusionStationBlockEntity.getColor(effect, blockEntity.getEffectAmplifier());
        }
        this.model.setUpForRender(hasPotion, hasPotion, hasPotion, true, potionColor);
        pose.func_227860_a_();
        if (transformType == ItemCameraTransforms.TransformType.GUI) {
            pose.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
            pose.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(225.0f));
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            pose.func_227861_a_(0.55, -1.5, -0.15);
            pose.func_227862_a_(0.85f, 0.95f, 0.9f);
        } else if (transformType == ItemCameraTransforms.TransformType.HEAD) {
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            pose.func_227861_a_(-0.5, -2.45, 0.5);
        } else if (transformType == ItemCameraTransforms.TransformType.GROUND) {
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            pose.func_227861_a_(-0.5, -1.0, 0.5);
            pose.func_227862_a_(0.45f, 0.45f, 0.45f);
        } else if (transformType == ItemCameraTransforms.TransformType.FIXED) {
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            pose.func_227861_a_(-0.5, -1.65, 0.5);
        } else if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            pose.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            pose.func_227861_a_(0.25, -1.0, -0.25);
            pose.func_227862_a_(0.45f, 0.45f, 0.45f);
            pose.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(25.0f));
        } else if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            pose.func_227861_a_(-0.6, -1.0, 0.25);
            pose.func_227862_a_(0.45f, 0.45f, 0.45f);
            pose.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(25.0f));
        } else if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            pose.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            pose.func_227861_a_(0.5, -1.0, -0.4);
            pose.func_227862_a_(0.45f, 0.45f, 0.45f);
        } else if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            pose.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            pose.func_227861_a_(-0.5, -1.0, 0.4);
            pose.func_227862_a_(0.45f, 0.45f, 0.45f);
        }
        RenderType renderType = RenderType.func_228642_d_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE);
        IVertexBuilder modelBuffer = buffer.getBuffer(renderType);
        this.model.func_225598_a_(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pose.func_227860_a_();
        pose.func_227861_a_(0.0, 1.0, 0.0);
        renderType = RenderType.func_228642_d_((ResourceLocation)IFElements.INFUSION_STATION_BLOCK_TEXTURE_TINT);
        modelBuffer = buffer.getBuffer(renderType);
        this.model.renderToBufferTint(pose, modelBuffer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f, true);
        pose.func_227865_b_();
        pose.func_227865_b_();
    }
}

