/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import xyz.apex.forge.infusedfoods.InfusedFoods;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.container.InfusionStationContainer;
import xyz.apex.forge.infusedfoods.init.IFElements;

public final class InfusionStationContainerScreen
extends ContainerScreen<InfusionStationContainer> {
    public InfusionStationContainerScreen(InfusionStationContainer menu, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)menu, playerInventory, title);
    }

    protected void func_231160_c_() {
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        super.func_231160_c_();
        this.field_238742_p_ = this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_) - 8;
    }

    public void func_230430_a_(MatrixStack pose, int mouseX, int mouseY, float partialTick) {
        this.func_230446_a_(pose);
        super.func_230430_a_(pose, mouseX, mouseY, partialTick);
        this.renderSlotBackground(pose, 1, 240, 0);
        this.renderSlotBackground(pose, 0, 240, 16);
        this.renderSlotBackground(pose, 2, 240, 33);
        this.renderInfusionFluid(pose);
        this.renderInfusionProgress(pose);
        this.renderInfusionFluidTankOverlay(pose, mouseX, mouseY);
        this.func_230459_a_(pose, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack pose, float partialTick, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(pose, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void renderSlotBackground(MatrixStack pose, int slotIndex, int backgroundX, int backgroundY) {
        Slot slot = ((InfusionStationContainer)this.field_147002_h).func_75139_a(slotIndex);
        if (!slot.func_75216_d()) {
            this.getMinecraft().func_110434_K().func_110577_a(IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
            InfusionStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)(this.field_147003_i + slot.field_75223_e), (int)(this.field_147009_r + slot.field_75221_f), (float)backgroundX, (float)backgroundY, (int)16, (int)16, (int)256, (int)256);
        }
    }

    private void renderInfusionFluidTankOverlay(MatrixStack pose, int mouseX, int mouseY) {
        int tankWidth = 16;
        int tankHeight = 40;
        int tankX = this.field_147003_i + 8;
        int tankY = this.field_147009_r + 8;
        this.getMinecraft().func_110434_K().func_110577_a(IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
        InfusionStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)tankX, (int)tankY, (float)176.0f, (float)41.0f, (int)tankWidth, (int)tankHeight, (int)256, (int)256);
        if (mouseX >= tankX && mouseY >= tankY && mouseX < tankX + tankWidth && mouseY < tankY + tankHeight) {
            this.func_238468_a_(pose, tankX, tankY, tankX + tankWidth, tankY + tankHeight, -2130706433, -2130706433);
            Effect effect = ((InfusionStationContainer)this.field_147002_h).blockEntity.getEffect();
            if (effect != null) {
                ArrayList tooltip = Lists.newArrayList();
                InfusedFoods.appendPotionEffectTooltips(effect, ((InfusionStationContainer)this.field_147002_h).blockEntity.getEffectAmplifier(), ((InfusionStationContainer)this.field_147002_h).blockEntity.getEffectDuration(), tooltip);
                this.renderWrappedToolTip(pose, tooltip, mouseX, mouseY, this.field_230712_o_);
            }
        }
    }

    private void renderInfusionFluid(MatrixStack pose) {
        Effect effect = ((InfusionStationContainer)this.field_147002_h).blockEntity.getEffect();
        if (effect != null) {
            int tankWidth = 16;
            int tankHeight = 40;
            int tankX = this.field_147003_i + 8;
            int tankY = this.field_147009_r + tankHeight;
            int fluidWidth = 16;
            int fluidHeight = 8;
            int fluidAmount = ((InfusionStationContainer)this.field_147002_h).blockEntity.getEffectAmount();
            int color = InfusionStationBlockEntity.getColor(effect, ((InfusionStationContainer)this.field_147002_h).blockEntity.getEffectAmplifier());
            this.getMinecraft().func_110434_K().func_110577_a(IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
            for (int i = 0; i < fluidAmount; ++i) {
                InfusionStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)tankX, (int)(tankY - i * fluidHeight), (float)176.0f, (float)33.0f, (int)fluidWidth, (int)fluidHeight, (int)256, (int)256);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderInfusionProgress(MatrixStack pose) {
        int j1;
        this.getMinecraft().func_110434_K().func_110577_a(IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
        int blazeFuel = ((InfusionStationContainer)this.field_147002_h).blockEntity.getBlazeFuel();
        int infuseTime = ((InfusionStationContainer)this.field_147002_h).blockEntity.getInfuseTime();
        int blazeWidth = MathHelper.func_76125_a((int)((18 * blazeFuel + 20 - 1) / 20), (int)0, (int)18);
        if (blazeWidth > 0) {
            InfusionStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)(this.field_147003_i + 89), (int)(this.field_147009_r + 72), (float)176.0f, (float)29.0f, (int)blazeWidth, (int)4, (int)256, (int)256);
        }
        if (infuseTime > 0 && (j1 = (int)(28.0f * (1.0f - (float)infuseTime / 400.0f))) > 0) {
            InfusionStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)(this.field_147003_i + 106), (int)(this.field_147009_r + 25), (float)189.0f, (float)0.0f, (int)j1, (int)9, (int)256, (int)256);
            InfusionStationContainerScreen.func_238463_a_((MatrixStack)pose, (int)(this.field_147003_i + 92), (int)(this.field_147009_r + 42 + 29 - j1), (float)176.0f, (float)(29 - j1), (int)13, (int)j1, (int)256, (int)256);
        }
    }
}

