/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.tags.ITag;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.EnchantmentEntry;
import xyz.apex.forge.utility.registrator.factory.EnchantmentFactory;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class EnchantmentBuilder<OWNER extends AbstractRegistrator<OWNER>, ENCHANTMENT extends Enchantment, PARENT>
extends RegistratorBuilder<OWNER, Enchantment, ENCHANTMENT, PARENT, EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT>, EnchantmentEntry<ENCHANTMENT>> {
    private final EnchantmentFactory<ENCHANTMENT> enchantmentFactory;
    private final Set<EquipmentSlotType> slotTypes = EnumSet.noneOf(EquipmentSlotType.class);
    private final EnchantmentType enchantmentType;
    private Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;

    public EnchantmentBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, EnchantmentType enchantmentType, EnchantmentFactory<ENCHANTMENT> enchantmentFactory) {
        super(owner, parent, registryName, callback, Enchantment.class, EnchantmentEntry::new, EnchantmentEntry::cast);
        this.enchantmentType = enchantmentType;
        this.enchantmentFactory = enchantmentFactory;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> rarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> slotType(EquipmentSlotType slotType) {
        this.slotTypes.add(slotType);
        return this;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> slotTypes(EquipmentSlotType ... slotTypes) {
        Collections.addAll(this.slotTypes, slotTypes);
        return this;
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> armorSlotTypes() {
        return this.slotTypes(EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET);
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> defaultLang() {
        return (EnchantmentBuilder)this.lang(Enchantment::func_77320_a);
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> lang(String name) {
        return (EnchantmentBuilder)this.lang(Enchantment::func_77320_a, name);
    }

    @SafeVarargs
    public final EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> tag(ITag.INamedTag<Enchantment> ... tags) {
        return (EnchantmentBuilder)this.tag(AbstractRegistrator.ENCHANTMENT_TAGS_PROVIDER, tags);
    }

    @SafeVarargs
    public final EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> removeTag(ITag.INamedTag<Enchantment> ... tags) {
        return (EnchantmentBuilder)this.removeTags(AbstractRegistrator.ENCHANTMENT_TAGS_PROVIDER, tags);
    }

    public EnchantmentBuilder<OWNER, ENCHANTMENT, PARENT> lang(String languageKey, String localizedValue) {
        return (EnchantmentBuilder)this.lang(languageKey, Enchantment::func_77320_a, localizedValue);
    }

    @Override
    @NonnullType
    protected ENCHANTMENT createEntry() {
        EquipmentSlotType[] slotTypes = this.slotTypes.toArray(new EquipmentSlotType[0]);
        return this.enchantmentFactory.create(this.rarity, this.enchantmentType, slotTypes);
    }
}

