/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.tags.ITag;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.entry.LazyRegistryEntry;
import xyz.apex.forge.utility.registrator.entry.RegistryEntry;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullConsumer;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.Builder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateTagsProvider;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;

public abstract class LegacyRegistratorBuilder<OWNER extends AbstractRegistrator<OWNER>, BASE extends IForgeRegistryEntry<BASE>, TYPE extends BASE, PARENT, BUILDER extends LegacyRegistratorBuilder<OWNER, BASE, TYPE, PARENT, BUILDER, ENTRY>, ENTRY extends RegistryEntry<TYPE>>
extends AbstractBuilder<BASE, TYPE, PARENT, BUILDER> {
    protected final OWNER owner;
    private final NonnullFunction<xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry<TYPE>, ENTRY> registryEntryCastor;
    private final LazyRegistryEntry<TYPE> safeSupplier = new LazyRegistryEntry(() -> (RegistryEntry)this.get());
    private final Map<String, Map<String, RegistryEvent.MissingMappings.Action>> mappings = Maps.newHashMap();
    private boolean registeredMappingsEvent = false;

    public LegacyRegistratorBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, Class<? super BASE> registryType, NonnullFunction<xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry<TYPE>, ENTRY> registryEntryCastor) {
        super(((AbstractRegistrator)owner).backend, parent, registryName, callback, registryType);
        this.owner = owner;
        this.registryEntryCastor = registryEntryCastor;
    }

    protected <OTHER_BASE extends IForgeRegistryEntry<OTHER_BASE>, OTHER_TYPE extends OTHER_BASE, OTHER_PARENT, OTHER_BUILDER extends LegacyRegistratorBuilder<OWNER, OTHER_BASE, OTHER_TYPE, OTHER_PARENT, OTHER_BUILDER, OTHER_ENTRY>, OTHER_ENTRY extends RegistryEntry<OTHER_TYPE>> void copyMappingsTo(LegacyRegistratorBuilder<OWNER, OTHER_BASE, OTHER_TYPE, OTHER_PARENT, OTHER_BUILDER, OTHER_ENTRY> other) {
        if (!this.mappings.isEmpty()) {
            this.mappings.forEach((gameVersion, updates) -> {
                Map otherUpdates = other.mappings.computeIfAbsent((String)gameVersion, $ -> Maps.newHashMap());
                updates.forEach((mappingName, action) -> {
                    if (!otherUpdates.containsKey(mappingName)) {
                        String modId = ((AbstractRegistrator)this.owner).getModId();
                        String registryType = this.getRegistryType().getSimpleName();
                        LogManager.getLogger().debug("Copied mapping '{}#{}:{}' from '{}#'", (Object)registryType, (Object)modId, mappingName, (Object)this.getRegistryNameFull());
                        otherUpdates.put(mappingName, action);
                    }
                });
            });
        }
    }

    public final BUILDER mapping(String gameVersion, String oldMapping, RegistryEvent.MissingMappings.Action action) {
        if (!this.registeredMappingsEvent) {
            MinecraftForge.EVENT_BUS.addGenericListener(this.getRegistryType(), this::onMissingMappings);
            this.registeredMappingsEvent = true;
        }
        this.mappings.computeIfAbsent(gameVersion, $ -> Maps.newHashMap()).put(oldMapping, action);
        return (BUILDER)this;
    }

    public final BUILDER mapping(String gameVersion, String oldMapping) {
        return this.mapping(gameVersion, oldMapping, RegistryEvent.MissingMappings.Action.REMAP);
    }

    private void onMissingMappings(RegistryEvent.MissingMappings<BASE> event) {
        String gameVersion = SharedConstants.func_215069_a().getReleaseTarget();
        if (this.mappings.containsKey(gameVersion)) {
            Map<String, RegistryEvent.MissingMappings.Action> updates = this.mappings.get(gameVersion);
            for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
                String mappingName;
                if (mapping.key == null || !mapping.key.func_110624_b().equals(((AbstractRegistrator)this.owner).getModId()) || !updates.containsKey(mappingName = mapping.key.func_110623_a())) continue;
                switch (updates.get(mappingName)) {
                    case WARN: {
                        mapping.warn();
                        break;
                    }
                    case FAIL: {
                        mapping.fail();
                        break;
                    }
                    case IGNORE: {
                        mapping.ignore();
                        break;
                    }
                    case REMAP: {
                        mapping.remap((IForgeRegistryEntry)this.safeSupplier.get());
                        break;
                    }
                }
            }
        }
    }

    protected abstract ENTRY createEntryWrapper(RegistryObject<TYPE> var1);

    public final ENTRY register() {
        return (ENTRY)((RegistryEntry)this.registryEntryCastor.apply(super.register()));
    }

    public final String getRegistryNameFull() {
        return ((AbstractRegistrator)this.owner).idString(this.getName());
    }

    @SafeVarargs
    public final BUILDER removeTags(ProviderType<? extends RegistrateTagsProvider<BASE>> providerType, ITag.INamedTag<BASE> ... tags) {
        return (BUILDER)((LegacyRegistratorBuilder)this.removeTag(providerType, tags));
    }

    public final OWNER getRegistrator() {
        return this.owner;
    }

    public final String getRegistryName() {
        return this.getName();
    }

    public final <PROVIDER extends RegistrateProvider> BUILDER setDataGenerator(ProviderType<? extends PROVIDER> providerType, NonnullBiConsumer<DataGenContext<BASE, TYPE>, PROVIDER> consumer) {
        return (BUILDER)this.setData((ProviderType)providerType, consumer::accept);
    }

    public final <PROVIDER extends RegistrateProvider> BUILDER clearDataGenerator(ProviderType<? extends PROVIDER> providerType) {
        return this.setDataGenerator(providerType, NonnullBiConsumer.noop());
    }

    public final <PROVIDER extends RegistrateProvider> BUILDER addMiscDataGenerator(ProviderType<? extends PROVIDER> providerType, NonnullConsumer<? super PROVIDER> consumer) {
        return (BUILDER)this.addMiscData((ProviderType)providerType, consumer::accept);
    }

    public final <OWNER_T extends AbstractRegistrator<OWNER_T>, BASE_T extends IForgeRegistryEntry<BASE_T>, TYPE_T extends BASE_T, PARENT_T, BUILDER_T extends LegacyRegistratorBuilder<OWNER_T, BASE_T, TYPE_T, PARENT_T, BUILDER_T, ENTRY_T>, ENTRY_T extends RegistryEntry<TYPE_T>> BUILDER_T transformer(NonnullFunction<BUILDER, BUILDER_T> transformer) {
        return (BUILDER_T)this.transform((NonNullFunction<BUILDER, BUILDER_T>)((NonNullFunction<LegacyRegistratorBuilder, LegacyRegistratorBuilder>)transformer::apply));
    }

    public final BUILDER lang(String languageKey, NonnullFunction<TYPE, String> translationKeyProvider, String localizedValue) {
        return this.setDataGenerator(AbstractRegistrator.LANG_EXT_PROVIDER, (ctx, provider) -> provider.add(languageKey, (String)translationKeyProvider.apply(ctx.get()), localizedValue));
    }

    @Override
    protected final BuilderCallback getCallback() {
        return super.getCallback();
    }

    @Override
    public final String getName() {
        return super.getName();
    }

    @Override
    @Deprecated
    public final AbstractRegistrate<?> getOwner() {
        return super.getOwner();
    }

    @Override
    public final PARENT getParent() {
        return (PARENT)super.getParent();
    }

    @Override
    public final Class<? super BASE> getRegistryType() {
        return super.getRegistryType();
    }

    @Override
    @Deprecated
    public final NonNullSupplier<TYPE> asSupplier() {
        return this.safeSupplier;
    }

    public final NonnullSupplier<TYPE> toSupplier() {
        return this.safeSupplier;
    }

    @Override
    public final BUILDER lang(net.minecraftforge.common.util.NonNullFunction<TYPE, String> langKeyProvider) {
        return (BUILDER)((LegacyRegistratorBuilder)super.lang(langKeyProvider));
    }

    @Override
    public final BUILDER lang(net.minecraftforge.common.util.NonNullFunction<TYPE, String> langKeyProvider, String name) {
        return (BUILDER)((LegacyRegistratorBuilder)super.lang(langKeyProvider, name));
    }

    @Override
    public final xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry<TYPE> get() {
        return ((AbstractRegistrator)this.owner).get(this.getName(), this.getRegistryType());
    }

    @Override
    public final TYPE getEntry() {
        return (TYPE)super.getEntry();
    }

    @Override
    public final <PROVIDER extends RegistrateProvider> BUILDER setData(ProviderType<? extends PROVIDER> providerType, NonNullBiConsumer<DataGenContext<BASE, TYPE>, PROVIDER> consumer) {
        return (BUILDER)((LegacyRegistratorBuilder)super.setData(providerType, consumer));
    }

    @Override
    public final <PROVIDER extends RegistrateProvider> BUILDER addMiscData(ProviderType<? extends PROVIDER> providerType, NonNullConsumer<? extends PROVIDER> consumer) {
        return (BUILDER)((LegacyRegistratorBuilder)super.addMiscData(providerType, consumer));
    }

    @Override
    public final BUILDER onRegister(NonNullConsumer<? super TYPE> callback) {
        return (BUILDER)((LegacyRegistratorBuilder)super.onRegister(callback));
    }

    @Override
    public final <OR extends IForgeRegistryEntry<OR>> BUILDER onRegisterAfter(Class<? super OR> dependencyType, NonNullConsumer<? super TYPE> callback) {
        return (BUILDER)((LegacyRegistratorBuilder)super.onRegisterAfter(dependencyType, callback));
    }

    @Override
    @Deprecated
    public final <BASE_T extends IForgeRegistryEntry<BASE_T>, TYPE_T extends BASE_T, PARENT_T, BUILDER_T extends Builder<BASE_T, TYPE_T, PARENT_T, BUILDER_T>> BUILDER_T transform(NonNullFunction<BUILDER, BUILDER_T> transformer) {
        return super.transform(transformer);
    }

    @Override
    public final PARENT build() {
        return (PARENT)super.build();
    }
}

