/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.village.PointOfInterestType;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.PointOfInterestEntry;
import xyz.apex.java.utility.nullness.NonnullBiPredicate;
import xyz.apex.java.utility.nullness.NonnullPredicate;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class PointOfInterestBuilder<OWNER extends AbstractRegistrator<OWNER>, PARENT>
extends RegistratorBuilder<OWNER, PointOfInterestType, PointOfInterestType, PARENT, PointOfInterestBuilder<OWNER, PARENT>, PointOfInterestEntry> {
    private NonnullSupplier<? extends Block> block = () -> Blocks.field_150350_a;
    private int maxTickets = 1;
    private Predicate predicate = (testType, thisType) -> testType == thisType;
    private int validRange = 1;

    public PointOfInterestBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback) {
        super(owner, parent, registryName, callback, PointOfInterestType.class, PointOfInterestEntry::new, PointOfInterestEntry::cast);
    }

    public PointOfInterestBuilder<OWNER, PARENT> matchingBlock(NonnullSupplier<? extends Block> block) {
        this.block = block;
        return this;
    }

    public PointOfInterestBuilder<OWNER, PARENT> maxTickets(int maxTickets) {
        this.maxTickets = maxTickets;
        return this;
    }

    public PointOfInterestBuilder<OWNER, PARENT> predicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public PointOfInterestBuilder<OWNER, PARENT> validRange(int validRange) {
        this.validRange = validRange;
        return this;
    }

    @Override
    @NonnullType
    protected PointOfInterestType createEntry() {
        AtomicReference<PointOfInterestType> result = new AtomicReference<PointOfInterestType>();
        NonnullPredicate<PointOfInterestType> predicate = poiType -> (Boolean)this.predicate.apply(poiType, result.get());
        Set matchingBlockStates = PointOfInterestType.func_221042_a((Block)this.block.get());
        String registryName = this.getRegistryNameFull();
        PointOfInterestType poiType2 = new PointOfInterestType(registryName, matchingBlockStates, this.maxTickets, predicate, this.validRange);
        result.set(poiType2);
        return poiType2;
    }

    @FunctionalInterface
    public static interface Predicate
    extends NonnullBiPredicate<PointOfInterestType, PointOfInterestType> {
        @Override
        public boolean test(PointOfInterestType var1, PointOfInterestType var2);
    }
}

