/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.data.template;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.utility.registrator.data.template.TemplatePools;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;

public final class TemplatePoolBuilder {
    private final TemplatePools pool;
    private final LinkedList<ElementBuilder> elements = Lists.newLinkedList();
    @Nullable
    private TemplatePools fallbackPool = TemplatePools.EMPTY;

    private TemplatePoolBuilder(TemplatePools pool) {
        this.pool = pool;
    }

    public TemplatePoolBuilder fallback(@Nullable TemplatePools fallbackPool) {
        this.fallbackPool = fallbackPool;
        return this;
    }

    public ElementBuilder element() {
        ElementBuilder element = new ElementBuilder(this);
        this.elements.add(element);
        return element;
    }

    public ElementBuilder element(int elementIndex) {
        return this.elements.get(elementIndex);
    }

    public ElementBuilder firstElement() {
        return this.elements.getFirst();
    }

    public ElementBuilder lastElement() {
        return this.elements.getLast();
    }

    public TemplatePools getPool() {
        return this.pool;
    }

    public ResourceLocation getPoolName() {
        return this.getPool().getPoolName();
    }

    public TemplatePools getFallbackPool() {
        return this.fallbackPool == null ? TemplatePools.EMPTY : this.fallbackPool;
    }

    public ResourceLocation getFallbackPoolName() {
        return this.getFallbackPool().getPoolName();
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getPoolName().toString());
        json.addProperty("fallback", this.getFallbackPoolName().toString());
        JsonArray elementsJson = new JsonArray();
        this.elements.stream().map(ElementBuilder::serialize).forEach(arg_0 -> ((JsonArray)elementsJson).add(arg_0));
        json.add("elements", (JsonElement)elementsJson);
        return json;
    }

    public static TemplatePoolBuilder builder(TemplatePools pool) {
        return new TemplatePoolBuilder(pool);
    }

    public static final class ElementBuilder {
        private final TemplatePoolBuilder poolBuilder;
        private int weight = 100;
        private Supplier<Structure<?>> structureSupplier = () -> null;
        private NonNullSupplier<StructureProcessorList> processorSupplier = () -> ProcessorLists.field_244101_a;
        private JigsawPattern.PlacementBehaviour projection = JigsawPattern.PlacementBehaviour.RIGID;
        private NonNullSupplier<IJigsawDeserializer<?>> elementTypeSupplier = () -> IJigsawDeserializer.field_214928_b;

        private ElementBuilder(TemplatePoolBuilder poolBuilder) {
            this.poolBuilder = poolBuilder;
        }

        public ElementBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public ElementBuilder location(NonNullSupplier<Structure<?>> structureSupplier) {
            this.structureSupplier = structureSupplier;
            return this;
        }

        public ElementBuilder processor(NonNullSupplier<StructureProcessorList> processorSupplier) {
            this.processorSupplier = processorSupplier;
            return this;
        }

        public ElementBuilder projection(JigsawPattern.PlacementBehaviour projection) {
            this.projection = projection;
            return this;
        }

        public ElementBuilder elementType(NonNullSupplier<IJigsawDeserializer<?>> elementTypeSupplier) {
            this.elementTypeSupplier = elementTypeSupplier;
            return this;
        }

        public int getWeight() {
            return MathHelper.func_76125_a((int)this.weight, (int)0, (int)100);
        }

        public Structure<?> getStructure() {
            return (Structure)Validate.notNull(this.structureSupplier.get());
        }

        public ResourceLocation getStructureName() {
            return (ResourceLocation)Validate.notNull((Object)this.getStructure().getRegistryName());
        }

        public StructureProcessorList getProcessor() {
            return this.processorSupplier.get();
        }

        public ResourceLocation getProcessorName() {
            return (ResourceLocation)Validate.notNull((Object)WorldGenRegistries.field_243655_g.func_177774_c((Object)this.getProcessor()));
        }

        public JigsawPattern.PlacementBehaviour getProjection() {
            return this.projection;
        }

        public String getProjectionName() {
            return this.getProjection().func_176610_l();
        }

        public IJigsawDeserializer<?> getElementType() {
            return this.elementTypeSupplier.get();
        }

        public ResourceLocation getElementTypeName() {
            return (ResourceLocation)Validate.notNull((Object)Registry.field_218365_F.func_177774_c(this.getElementType()));
        }

        public JsonObject serialize() {
            JsonObject element = new JsonObject();
            element.addProperty("location", this.getStructureName().toString());
            element.addProperty("processors", this.getProcessorName().toString());
            element.addProperty("projection", this.getProjectionName());
            element.addProperty("element_type", this.getElementTypeName().toString());
            JsonObject json = new JsonObject();
            json.addProperty("weight", (Number)this.getWeight());
            json.add("element", (JsonElement)element);
            return json;
        }

        public TemplatePoolBuilder end() {
            return this.poolBuilder;
        }
    }
}

