/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.data.template;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.apex.forge.utility.registrator.data.template.TemplatePoolBuilder;
import xyz.apex.forge.utility.registrator.data.template.TemplatePools;

public abstract class TemplatePoolProvider
implements IDataProvider {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger LOGGER = LogManager.getLogger();
    protected final DataGenerator generator;
    private final Map<TemplatePools, TemplatePoolBuilder> poolBuilderMap = Maps.newHashMap();

    protected TemplatePoolProvider(DataGenerator generator) {
        this.generator = generator;
    }

    protected abstract void registerPools();

    public TemplatePoolBuilder pool(TemplatePools pool) {
        return this.poolBuilderMap.computeIfAbsent(pool, TemplatePoolBuilder::builder);
    }

    public TemplatePoolBuilder pool(ResourceLocation poolName) {
        return this.pool(TemplatePools.of(poolName));
    }

    public TemplatePoolBuilder pool(String poolNamespace, String poolPath) {
        return this.pool(TemplatePools.of(poolNamespace, poolPath));
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.poolBuilderMap.clear();
        this.registerPools();
        Path dataPath = this.generator.func_200391_b().resolve("data");
        this.poolBuilderMap.forEach((poolName, poolBuilder) -> TemplatePoolProvider.saveTemplatePool(cache, poolBuilder, dataPath));
    }

    public String func_200397_b() {
        return "TemplatePollProvider";
    }

    public static void saveTemplatePool(DirectoryCache cache, TemplatePoolBuilder builder, Path dataPath) {
        try {
            ResourceLocation poolName = builder.getPoolName();
            Path poolPath = dataPath.resolve(Paths.get(poolName.func_110624_b(), "worldgen", "template_pool", poolName.func_110623_a() + ".json"));
            JsonObject serialized = builder.serialize();
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)serialized, (Path)poolPath);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save TemplatePool {}", (Object)builder.getPoolName(), (Object)e);
        }
    }
}

