/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.entry;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.entry.RegistryEntry;
import xyz.apex.java.utility.nullness.NonnullConsumer;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class ContainerEntry<CONTAINER extends Container>
extends RegistryEntry<ContainerType<CONTAINER>>
implements IContainerProvider,
NonnullSupplier<ContainerType<CONTAINER>> {
    public ContainerEntry(AbstractRegistrator<?> registrator, RegistryObject<ContainerType<CONTAINER>> delegate) {
        super(registrator, delegate);
    }

    public ContainerType<CONTAINER> asContainerType() {
        return (ContainerType)this.get();
    }

    public CONTAINER create(int windowId, PlayerInventory playerInventory, @Nullable PacketBuffer extraData) {
        return (CONTAINER)this.asContainerType().create(windowId, playerInventory, extraData);
    }

    public CONTAINER create(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return this.create(windowId, playerInventory, (PacketBuffer)null);
    }

    public CONTAINER create(int windowId, PlayerInventory playerInventory) {
        return this.create(windowId, playerInventory, (PacketBuffer)null);
    }

    public INamedContainerProvider asNamedProvider(ITextComponent titleComponent) {
        return new SimpleNamedContainerProvider((IContainerProvider)this, titleComponent);
    }

    public void open(ServerPlayerEntity player, INamedContainerProvider containerProvider, NonnullConsumer<PacketBuffer> extraData) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, extraData);
    }

    public void open(ServerPlayerEntity player, INamedContainerProvider containerProvider) {
        this.open(player, containerProvider, NonnullConsumer.noop());
    }

    public void open(ServerPlayerEntity player, ITextComponent titleComponent, NonnullConsumer<PacketBuffer> extraData) {
        this.open(player, this.asNamedProvider(titleComponent), extraData);
    }

    public void open(ServerPlayerEntity player, ITextComponent titleComponent) {
        this.open(player, this.asNamedProvider(titleComponent), NonnullConsumer.noop());
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return this.create(windowId, playerInventory, player);
    }

    public static <CONTAINER extends Container> ContainerEntry<CONTAINER> cast(RegistryEntry<ContainerType<CONTAINER>> registryEntry) {
        return ContainerEntry.cast(ContainerEntry.class, registryEntry);
    }

    public static <CONTAINER extends Container> ContainerEntry<CONTAINER> cast(xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry<ContainerType<CONTAINER>> registryEntry) {
        return ContainerEntry.cast(ContainerEntry.class, registryEntry);
    }
}

