/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public class ForgeSpawnEggItem<ENTITY extends Entity>
extends SpawnEggItem {
    private static final IDispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
        EntityType entityType = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
        try {
            entityType.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
        }
        catch (Exception e) {
            LogManager.getLogger().error("Error while dispensing spawn egg from dispenser at {}", (Object)source.func_180699_d(), (Object)e);
            return ItemStack.field_190927_a;
        }
        stack.func_190918_g(1);
        return stack;
    };
    private boolean registered = false;
    private final NonnullSupplier<EntityType<ENTITY>> entityTypeSupplier;

    public ForgeSpawnEggItem(NonnullSupplier<EntityType<ENTITY>> entityTypeSupplier, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(null, backgroundColor, highlightColor, properties);
        this.entityTypeSupplier = entityTypeSupplier;
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT tag) {
        EntityType<ENTITY> entityType = super.func_208076_b(tag);
        return entityType == null ? this.entityTypeSupplier.get() : entityType;
    }

    @Nullable
    protected IDispenseItemBehavior getDispenserBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Deprecated
    public final void registerSpawnEggProperties() {
        if (this.registered) {
            return;
        }
        field_195987_b.put(this.entityTypeSupplier.get(), this);
        this.registered = true;
        IDispenseItemBehavior dispenserBehavior = this.getDispenserBehavior();
        if (dispenserBehavior != null) {
            DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)dispenserBehavior);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getSpawnEggColor(ItemStack stack, int tintIndex) {
        Item item = stack.func_77973_b();
        return item instanceof SpawnEggItem ? ((SpawnEggItem)item).func_195983_a(tintIndex) : 0;
    }
}

