/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import com.google.common.base.Objects;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import xyz.apex.java.utility.Lazy;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class ItemTier
implements IItemTier {
    public final int level;
    public final int uses;
    public final float speed;
    public final float damage;
    public final int enchantmentValue;
    public final Lazy<Ingredient> repairIngredient;

    public ItemTier(int level, int uses, float speed, float damage, int enchantmentValue, NonnullSupplier<Ingredient> repairIngredient) {
        this.level = level;
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Lazy.of(repairIngredient, true);
    }

    private ItemTier(Builder builder) {
        this.level = builder.level;
        this.uses = builder.uses;
        this.speed = builder.speed;
        this.damage = builder.damage;
        this.enchantmentValue = builder.enchantmentValue;
        this.repairIngredient = Lazy.of(builder.repairIngredient, true);
    }

    public int func_200926_a() {
        return this.uses;
    }

    public float func_200928_b() {
        return this.speed;
    }

    public float func_200929_c() {
        return this.damage;
    }

    public int func_200925_d() {
        return this.level;
    }

    public int func_200927_e() {
        return this.enchantmentValue;
    }

    public Ingredient func_200924_f() {
        return this.repairIngredient.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemTier itemTier = (ItemTier)o;
        return this.level == itemTier.level && this.uses == itemTier.uses && Float.compare(itemTier.speed, this.speed) == 0 && Float.compare(itemTier.damage, this.damage) == 0 && this.enchantmentValue == itemTier.enchantmentValue && Objects.equal(this.repairIngredient, itemTier.repairIngredient);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.level, this.uses, Float.valueOf(this.speed), Float.valueOf(this.damage), this.enchantmentValue, this.repairIngredient});
    }

    public String toString() {
        return "ItemTier{level=" + this.level + ", uses=" + this.uses + ", speed=" + this.speed + ", damage=" + this.damage + ", enchantmentValue=" + this.enchantmentValue + ", repairIngredient=" + this.repairIngredient + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(IItemTier itemTier) {
        return ItemTier.builder().copy(itemTier);
    }

    public static final class Builder {
        private int level = 0;
        private int uses = 1;
        private float speed = 1.0f;
        private float damage = 0.0f;
        private int enchantmentValue = 0;
        private NonnullSupplier<Ingredient> repairIngredient = () -> Ingredient.field_193370_a;

        private Builder() {
        }

        public Builder copy(Builder builder) {
            return this.level(builder.level).uses(builder.uses).speed(builder.speed).damage(builder.damage).enchantmentValue(builder.enchantmentValue).repairIngredient(builder.repairIngredient);
        }

        public Builder copy(IItemTier itemTier) {
            return this.level(itemTier.func_200925_d()).uses(itemTier.func_200926_a()).speed(itemTier.func_200928_b()).damage(itemTier.func_200929_c()).enchantmentValue(itemTier.func_200927_e()).repairIngredient(() -> ((IItemTier)itemTier).func_200924_f());
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder uses(int uses) {
            this.uses = uses;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder damage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder repairIngredient(NonnullSupplier<Ingredient> repairIngredient) {
            this.repairIngredient = repairIngredient;
            return this;
        }

        public Builder repairIngredient(ITag<Item> repairIngredient) {
            return this.repairIngredient(() -> Ingredient.func_199805_a((ITag)repairIngredient));
        }

        public Builder repairIngredient(IItemProvider ... repairIngredients) {
            return this.repairIngredient(() -> Ingredient.func_199804_a((IItemProvider[])repairIngredients));
        }

        public IItemTier build() {
            return new ItemTier(this);
        }
    }
}

