/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.state.Property;
import net.minecraft.util.Util;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;

public final class BlockListReporter
implements IDataProvider {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrator<?> registrator;
    private final DataGenerator generator;

    public BlockListReporter(AbstractRegistrator<?> registrator, DataGenerator generator) {
        this.registrator = registrator;
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b().resolve(Paths.get("reports", this.registrator.getModId(), "blocks.json"));
        JsonObject json = this.serializeBlocks();
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)path);
    }

    public String func_200397_b() {
        return "Block List: " + this.registrator.getModId();
    }

    private Iterable<Block> getBlocks() {
        return (Iterable)this.registrator.getAll(Block.class).stream().filter(RegistryEntry::isPresent).sorted((a, b) -> a.getId().compareNamespaced(b.getId())).distinct().map(RegistryEntry::get).collect(ImmutableList.toImmutableList());
    }

    private JsonObject serializeBlocks() {
        JsonObject json = new JsonObject();
        this.getBlocks().forEach(block -> json.add(Objects.requireNonNull(block.getRegistryName()).toString(), (JsonElement)this.serializeBlock((Block)block)));
        return json;
    }

    private JsonObject serializeBlock(Block block) {
        JsonObject blockJson = new JsonObject();
        blockJson.add("properties", (JsonElement)this.serializeBlockProperties(block));
        blockJson.add("states", (JsonElement)this.serializeBlockStates(block));
        return blockJson;
    }

    private JsonObject serializeBlockProperties(Block block) {
        JsonObject json = new JsonObject();
        block.func_176194_O().func_177623_d().forEach(property -> json.add(property.func_177701_a(), (JsonElement)this.serializeBlockPropertyPossibleValues((Property<?>)property)));
        return json;
    }

    private JsonArray serializeBlockPropertyPossibleValues(Property<?> property) {
        JsonArray json = new JsonArray();
        property.func_177700_c().stream().map(comparable -> Util.func_200269_a((Property)property, (Object)comparable)).forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        return json;
    }

    private JsonArray serializeBlockStates(Block block) {
        JsonArray json = new JsonArray();
        block.func_176194_O().func_177619_a().stream().map(blockState -> this.serializeBlockState(block, (BlockState)blockState)).forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        return json;
    }

    private JsonObject serializeBlockState(Block block, BlockState blockState) {
        JsonObject json = new JsonObject();
        json.add("properties", (JsonElement)this.serializeBlockStateProperties(block, blockState));
        json.addProperty("id", (Number)Block.func_196246_j((BlockState)blockState));
        json.addProperty("default", Boolean.valueOf(blockState == block.func_176223_P()));
        return json;
    }

    private JsonObject serializeBlockStateProperties(Block block, BlockState blockState) {
        JsonObject json = new JsonObject();
        block.func_176194_O().func_177623_d().forEach(property -> json.addProperty(property.func_177701_a(), Util.func_200269_a((Property)property, (Object)blockState.func_177229_b(property))));
        return json;
    }
}

