/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.loot.LootTables;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.builders.ItemBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.TileEntityBuilder;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.entry.BlockEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullUnaryOperator;

public class BlockBuilder<T extends Block, P>
extends AbstractBuilder<Block, T, P, BlockBuilder<T, P>> {
    private final NonNullFunction<AbstractBlock.Properties, T> factory;
    private NonNullSupplier<AbstractBlock.Properties> initialProperties;
    private NonNullFunction<AbstractBlock.Properties, AbstractBlock.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    private List<Supplier<Supplier<RenderType>>> renderLayers = new ArrayList<Supplier<Supplier<RenderType>>>(1);
    @Nullable
    private NonNullSupplier<Supplier<IBlockColor>> colorHandler;

    public static <T extends Block, P> BlockBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<AbstractBlock.Properties, T> factory, Material material) {
        return new BlockBuilder<T, P>(owner, parent, name, callback, factory, () -> AbstractBlock.Properties.func_200945_a((Material)material)).defaultBlockstate().defaultLoot().defaultLang();
    }

    protected BlockBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<AbstractBlock.Properties, T> factory, NonNullSupplier<AbstractBlock.Properties> initialProperties) {
        super(owner, parent, name, callback, Block.class);
        this.factory = factory;
        this.initialProperties = initialProperties;
    }

    public BlockBuilder<T, P> properties(NonNullUnaryOperator<AbstractBlock.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200945_a((Material)material);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, DyeColor color) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200952_a((Material)material, (DyeColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, MaterialColor color) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(NonNullSupplier<? extends Block> block) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)block.get()));
        return this;
    }

    public BlockBuilder<T, P> addLayer(Supplier<Supplier<RenderType>> layer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> BlockBuilder.lambda$null$5((Supplier)layer));
        if (this.renderLayers.isEmpty()) {
            this.onRegister(this::registerLayers);
        }
        this.renderLayers.add(layer);
        return this;
    }

    protected void registerLayers(T entry) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.renderLayers.size() == 1) {
                RenderType layer = this.renderLayers.get(0).get().get();
                RenderTypeLookup.setRenderLayer((Block)entry, (RenderType)layer);
            } else if (this.renderLayers.size() > 1) {
                Set layers = this.renderLayers.stream().map(s -> (RenderType)((Supplier)s.get()).get()).collect(Collectors.toSet());
                RenderTypeLookup.setRenderLayer((Block)entry, layers::contains);
            }
        });
    }

    public BlockBuilder<T, P> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public ItemBuilder<BlockItem, BlockBuilder<T, P>> item() {
        return this.item(BlockItem::new);
    }

    public <I extends BlockItem> ItemBuilder<I, BlockBuilder<T, P>> item(NonNullBiFunction<? super T, Item.Properties, ? extends I> factory) {
        return ((ItemBuilder)this.getOwner().item(this, this.getName(), p -> (BlockItem)factory.apply((T)this.getEntry(), (Item.Properties)p)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> {
            Optional<String> model = this.getOwner().getDataProvider(ProviderType.BLOCKSTATE).flatMap(p -> p.getExistingVariantBuilder((Block)this.getEntry())).map(b -> (BlockStateProvider.ConfiguredModelList)b.getModels().get(b.partialState())).map(BlockStateProvider.ConfiguredModelList::toJSON).filter(JsonElement::isJsonObject).map(j -> j.getAsJsonObject().get("model")).map(JsonElement::getAsString);
            if (model.isPresent()) {
                prov.withExistingParent(ctx.getName(), model.get());
            } else {
                prov.blockItem(this.asSupplier());
            }
        });
    }

    @Deprecated
    public <TE extends TileEntity> BlockBuilder<T, P> simpleTileEntity(NonNullSupplier<? extends TE> factory) {
        return (BlockBuilder)this.tileEntity(factory).build();
    }

    public <TE extends TileEntity> BlockBuilder<T, P> simpleTileEntity(NonNullFunction<TileEntityType<TE>, ? extends TE> factory) {
        return (BlockBuilder)this.tileEntity(factory).build();
    }

    @Deprecated
    public <TE extends TileEntity> TileEntityBuilder<TE, BlockBuilder<T, P>> tileEntity(NonNullSupplier<? extends TE> factory) {
        return this.getOwner().tileEntity(this, this.getName(), factory).validBlock(this.asSupplier());
    }

    public <TE extends TileEntity> TileEntityBuilder<TE, BlockBuilder<T, P>> tileEntity(NonNullFunction<TileEntityType<TE>, ? extends TE> factory) {
        return this.getOwner().tileEntity(this, this.getName(), factory).validBlock(this.asSupplier());
    }

    public BlockBuilder<T, P> color(NonNullSupplier<Supplier<IBlockColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerBlockColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerBlockColor() {
        OneTimeEventReceiver.addModListener(ColorHandlerEvent.Block.class, e -> {
            NonNullSupplier<Supplier<IBlockColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.getBlockColors().func_186722_a(colorHandler.get().get(), new Block[]{(Block)this.getEntry()});
            }
        });
    }

    public BlockBuilder<T, P> defaultBlockstate() {
        return this.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry()));
    }

    public BlockBuilder<T, P> blockstate(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, cons);
    }

    public BlockBuilder<T, P> defaultLang() {
        return (BlockBuilder)this.lang(Block::func_149739_a);
    }

    public BlockBuilder<T, P> lang(String name) {
        return (BlockBuilder)this.lang(Block::func_149739_a, name);
    }

    public BlockBuilder<T, P> defaultLoot() {
        return this.loot(BlockLootTables::func_218492_c);
    }

    public BlockBuilder<T, P> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> cons) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, tb -> {
            if (!((Block)ctx.getEntry()).func_220068_i().equals((Object)LootTables.field_186419_a)) {
                cons.accept((RegistrateBlockLootTables)tb, (Object)ctx.getEntry());
            }
        }));
    }

    public BlockBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final BlockBuilder<T, P> tag(ITag.INamedTag<Block> ... tags) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        AbstractBlock.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Block)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new BlockEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public BlockEntry<T> register() {
        return (BlockEntry)super.register();
    }

    private static /* synthetic */ void lambda$null$5(Supplier layer) {
        Preconditions.checkArgument((boolean)RenderType.func_228661_n_().contains(((Supplier)layer.get()).get()), (Object)("Invalid block layer: " + layer));
    }
}

