/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateProvider;
import xyz.apex.repack.com.tterrag.registrate.util.DataIngredient;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;

public class RegistrateRecipeProvider
extends RecipeProvider
implements RegistrateProvider,
Consumer<IFinishedRecipe> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<IFinishedRecipe> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<CookingRecipeSerializer<?>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)IRecipeSerializer.field_222171_o, (Object)"smelting").put((Object)IRecipeSerializer.field_222172_p, (Object)"blasting").put((Object)IRecipeSerializer.field_222173_q, (Object)"smoking").put((Object)IRecipeSerializer.field_222174_r, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, DataGenerator generatorIn) {
        super(generatorIn);
        this.owner = owner;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void accept(@Nullable IFinishedRecipe t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    public ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(this.owner.getModid(), this.safeName(id));
    }

    public ResourceLocation safeId(DataIngredient source) {
        return this.safeId(source.getId());
    }

    public ResourceLocation safeId(IForgeRegistryEntry<?> registryEntry) {
        return this.safeId(registryEntry.getRegistryName());
    }

    public String safeName(ResourceLocation id) {
        return id.func_110623_a().replace('/', '_');
    }

    public String safeName(DataIngredient source) {
        return this.safeName(source.getId());
    }

    public String safeName(IForgeRegistryEntry<?> registryEntry) {
        return this.safeName(registryEntry.getRegistryName());
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, CookingRecipeSerializer<?> serializer) {
        this.cooking(source, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, String typeName, CookingRecipeSerializer<?> serializer) {
        CookingRecipeBuilder.func_218631_a((Ingredient)source, (IItemProvider)((IItemProvider)result.get()), (float)experience, (int)cookingTime, serializer).func_218628_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_218632_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName(source) + "_" + typeName);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smelting(source, result, experience, 200);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smelting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222171_o);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void blasting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.blasting(source, result, experience, 100);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void blasting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222172_p);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smoking(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smoking(source, result, experience, 100);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smoking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222173_q);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void campfire(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.campfire(source, result, experience, 600);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void campfire(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, IRecipeSerializer.field_222174_r);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stonecutting(DataIngredient source, Supplier<? extends T> result) {
        this.stonecutting(source, result, 1);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stonecutting(DataIngredient source, Supplier<? extends T> result, int resultAmount) {
        SingleItemRecipeBuilder.func_218644_a((Ingredient)source, (IItemProvider)((IItemProvider)result.get()), (int)resultAmount).func_218643_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_218645_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()) + "_from_" + this.safeName(source) + "_stonecutting");
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void smeltingAndBlasting(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.blasting(source, result, xp);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void food(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.smoking(source, result, xp);
        this.campfire(source, result, xp);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void square(DataIngredient source, Supplier<? extends T> output, boolean small) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)output.get())).func_200471_a(Character.valueOf('X'), (Ingredient)source);
        if (small) {
            builder.func_200472_a("XX").func_200472_a("XX");
        } else {
            builder.func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX");
        }
        builder.func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)output.get()));
    }

    @Deprecated
    public <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(DataIngredient source, NonNullSupplier<? extends T> output) {
        this.square(source, output, false);
        this.singleItemUnfinished(source, output, 1, 9).func_200484_a((Consumer)this, this.safeId(source) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(NonNullSupplier<? extends T> source, NonNullSupplier<? extends T> output) {
        this.storage(DataIngredient.items(source, new NonNullSupplier[0]), source, DataIngredient.items(output, new NonNullSupplier[0]), output);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void storage(DataIngredient sourceIngredient, NonNullSupplier<? extends T> source, DataIngredient outputIngredient, NonNullSupplier<? extends T> output) {
        this.square(sourceIngredient, output, false);
        this.singleItemUnfinished(outputIngredient, source, 1, 9).func_200484_a((Consumer)this, this.safeId(sourceIngredient) + "_from_" + this.safeName((IForgeRegistryEntry)output.get()));
    }

    @CheckReturnValue
    public <T extends IItemProvider & IForgeRegistryEntry<?>> ShapelessRecipeBuilder singleItemUnfinished(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)amount).func_200492_a((Ingredient)source, required).func_200483_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void singleItem(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        this.singleItemUnfinished(source, result, required, amount).func_200485_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void planks(DataIngredient source, Supplier<? extends T> result) {
        this.singleItemUnfinished(source, result, 1, 4).func_200490_a("planks").func_200485_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void stairs(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200472_a("X  ").func_200472_a("XX ").func_200472_a("XXX").func_200471_a(Character.valueOf('X'), (Ingredient)source).func_200473_b(group).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
        if (stone) {
            this.stonecutting(source, result);
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void slab(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200471_a(Character.valueOf('X'), (Ingredient)source).func_200473_b(group).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
        if (stone) {
            this.stonecutting(source, result, 2);
        }
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void fence(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("W#W").func_200472_a("W#W").func_200471_a(Character.valueOf('W'), (Ingredient)source).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void fenceGate(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("#W#").func_200472_a("#W#").func_200471_a(Character.valueOf('W'), (Ingredient)source).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b(group).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void wall(DataIngredient source, Supplier<? extends T> result) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("XXX").func_200472_a("XXX").func_200471_a(Character.valueOf('X'), (Ingredient)source).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
        this.stonecutting(source, result);
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void door(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("XX").func_200472_a("XX").func_200472_a("XX").func_200471_a(Character.valueOf('X'), (Ingredient)source).func_200473_b(group).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public <T extends IItemProvider & IForgeRegistryEntry<?>> void trapDoor(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)2).func_200472_a("XXX").func_200472_a("XXX").func_200471_a(Character.valueOf('X'), (Ingredient)source).func_200473_b(group).func_200465_a("has_" + this.safeName(source), (ICriterionInstance)source.getCritereon(this)).func_200467_a((Consumer)this, this.safeId((IForgeRegistryEntry)result.get()));
    }

    public void func_208310_b(DirectoryCache cache, JsonObject cache2, Path advancementJson) {
        super.func_208310_b(cache, cache2, advancementJson);
    }

    public static EnterBlockTrigger.Instance enteredBlock(Block block) {
        return RecipeProvider.func_200407_a((Block)block);
    }

    public static InventoryChangeTrigger.Instance hasItem(IItemProvider item) {
        return RecipeProvider.func_200403_a((IItemProvider)item);
    }

    public static InventoryChangeTrigger.Instance hasItem(ITag<Item> tag) {
        return RecipeProvider.func_200409_a(tag);
    }

    public static InventoryChangeTrigger.Instance hasItem(ItemPredicate ... predicate) {
        return RecipeProvider.func_200405_a((ItemPredicate[])predicate);
    }
}

