/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.block;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.init.PlayerPlushie;
import xyz.apex.forge.apexcore.lib.block.BlockEntityBlock;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;

public final class PlayerPlushieBlock
extends BlockEntityBlock<PlayerPlushieBlockEntity>
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE = PlayerPlushieBlock.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)13.0, (double)14.0);
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal(SHAPE, Direction.NORTH);

    public PlayerPlushieBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader level, BlockPos pos, ISelectionContext ctx) {
        Direction facing = (Direction)blockState.func_177229_b((Property)FACING);
        return SHAPER.get(facing);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d());
        FluidState fluidState = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        boolean waterLogged = fluidState.func_206884_a((ITag)FluidTags.field_206959_a);
        return (BlockState)blockState.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged));
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader level, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) == false;
    }

    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingBlockState, IWorld level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            level.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(blockState, facing, facingBlockState, level, pos, facingPos);
    }

    public boolean func_196266_a(BlockState blockState, IBlockReader level, BlockPos pos, PathType pathType) {
        return false;
    }

    public void func_180633_a(World level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        SupporterManager.SupporterInfo supporterInfo = PlayerPlushie.getSupporterInfo(stack);
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)((Object)this.getBlockEntity((IBlockReader)level, pos));
        if (blockEntity != null && supporterInfo != null) {
            blockEntity.setSupporterInfo(supporterInfo);
        }
    }

    public void func_149666_a(ItemGroup itemGroup, NonNullList<ItemStack> stacks) {
        stacks.addAll(PlayerPlushie.getPlushieItems());
    }

    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected TileEntityType<PlayerPlushieBlockEntity> getBlockEntityType() {
        return PlayerPlushie.PLAYER_PLUSHIE_BLOCK_ENTITY.asBlockEntityType();
    }

    public ItemStack getPickBlock(BlockState blockState, RayTraceResult result, IBlockReader level, BlockPos pos, PlayerEntity player) {
        SupporterManager.SupporterInfo supporterInfo;
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)((Object)this.getBlockEntity(level, pos));
        if (blockEntity != null && (supporterInfo = blockEntity.getSupporterInfo()) != null) {
            return PlayerPlushie.getPlushieItem(supporterInfo);
        }
        return super.getPickBlock(blockState, result, level, pos, player);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        SupporterManager.SupporterInfo info = PlayerPlushie.getSupporterInfo(stack);
        if (info != null) {
            String username = info.getUsername();
            if (level instanceof World) {
                World world = (World)level;
                PlayerEntity player = info.getPlayer(arg_0 -> ((World)world).func_217371_b(arg_0));
                if (player != null) {
                    username = player.func_195047_I_();
                }
            }
            String supportLevelName = info.getLevel().func_176610_l().toLowerCase(Locale.ROOT);
            String letter = supportLevelName.substring(0, 1).toUpperCase(Locale.ROOT);
            supportLevelName = letter + supportLevelName.substring(1);
            tooltip.add((ITextComponent)new StringTextComponent(username).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}).func_240702_b_(" (").func_230529_a_((ITextComponent)new StringTextComponent(supportLevelName).func_240699_a_(TextFormatting.AQUA)).func_240702_b_(")"));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
        super.func_206840_a(builder);
    }

    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)blockState.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a((Direction)blockState.func_177229_b((Property)FACING)));
    }
}

