/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.extensions.IForgeEffectInstance;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategory;
import xyz.apex.forge.apexcore.lib.item.ItemGroupCategoryManager;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="apexcore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class CreativeScreenHandler {
    private static final ResourceLocation CATEGORY_TABS_TEXTURE = new ResourceLocation("apexcore", "textures/gui/container/creative_inventory/category_tabs.png");
    private static final int MAX_CATEGORY_TAB = 4;
    private static final int CATEGORY_TAB_U_SIZE = 32;
    private static final int CATEGORY_TAB_V_SIZE = 28;
    private static final int CATEGORY_TABS_TEXTURE_WIDTH = 64;
    private static final int CATEGORY_TABS_TEXTURE_HEIGHT = 28;
    private static int categoryTabPage = 0;
    private static int maxCategoryTabPages = 0;
    @Nullable
    private static Button buttonPreviousCategoryPage;
    @Nullable
    private static Button buttonNextCategoryPage;

    @SubscribeEvent
    public static void onScreenInit(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            buttonNextCategoryPage = new Button(0, 0, 1, 1, (ITextComponent)new StringTextComponent("V"), b -> {
                categoryTabPage = Math.min(categoryTabPage + 1, maxCategoryTabPages);
            });
            CreativeScreenHandler.buttonNextCategoryPage.field_230693_o_ = false;
            CreativeScreenHandler.buttonNextCategoryPage.field_230694_p_ = false;
            event.addWidget((Widget)buttonNextCategoryPage);
            buttonPreviousCategoryPage = new Button(0, 0, 1, 1, (ITextComponent)new StringTextComponent("^"), b -> {
                categoryTabPage = Math.max(categoryTabPage - 1, 0);
            });
            CreativeScreenHandler.buttonPreviousCategoryPage.field_230693_o_ = false;
            CreativeScreenHandler.buttonPreviousCategoryPage.field_230694_p_ = false;
            event.addWidget((Widget)buttonPreviousCategoryPage);
            ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
            CreativeScreenHandler.updatePages(screen, selectedTab);
        }
    }

    private static void updatePages(CreativeScreen screen, @Nullable ItemGroup itemGroup) {
        ItemGroupCategoryManager manager;
        Set<ItemGroupCategory> categories;
        int tabCount;
        Validate.notNull((Object)buttonPreviousCategoryPage);
        Validate.notNull((Object)buttonNextCategoryPage);
        int leftPos = screen.getGuiLeft();
        int topPos = screen.getGuiTop();
        int buttonSize = 20;
        CreativeScreenHandler.buttonPreviousCategoryPage.field_230690_l_ = leftPos - 64 + 7;
        CreativeScreenHandler.buttonPreviousCategoryPage.field_230691_m_ = topPos + 2;
        buttonPreviousCategoryPage.func_230991_b_(buttonSize);
        buttonPreviousCategoryPage.setHeight(buttonSize);
        CreativeScreenHandler.buttonNextCategoryPage.field_230690_l_ = CreativeScreenHandler.buttonPreviousCategoryPage.field_230690_l_;
        CreativeScreenHandler.buttonNextCategoryPage.field_230691_m_ = CreativeScreenHandler.buttonPreviousCategoryPage.field_230691_m_ + 96;
        buttonNextCategoryPage.func_230991_b_(buttonSize);
        buttonNextCategoryPage.setHeight(buttonSize);
        maxCategoryTabPages = 0;
        if (CreativeScreenHandler.isSupportedTab(itemGroup) && (tabCount = (categories = (manager = ItemGroupCategoryManager.getInstance(itemGroup)).getCategories()).size()) > 4) {
            maxCategoryTabPages = (int)Math.ceil((double)(tabCount - 4) / 2.0);
        }
    }

    public static void selectTab_FilterItems(CreativeScreen screen, ItemGroup itemGroup) {
        if (CreativeScreenHandler.isSupportedTab(itemGroup)) {
            ItemGroupCategoryManager.getInstance(itemGroup).applyFilter((NonNullList<ItemStack>)((CreativeScreen.CreativeContainer)screen.func_212873_a_()).field_148330_a);
        }
    }

    public static void selectTab_Head(CreativeScreen screen, ItemGroup itemGroup) {
        ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (CreativeScreenHandler.isSupportedTab(selectedTab)) {
            ItemGroupCategoryManager.getInstance(selectedTab).disableCategories();
            categoryTabPage = 0;
        }
        CreativeScreenHandler.updatePages(screen, itemGroup);
    }

    public static void renderBg(CreativeScreen screen, MatrixStack pose) {
        ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        CreativeScreenHandler.renderTabButton(screen, pose, selectedTab, false);
        CreativeScreenHandler.renderTabButton(screen, pose, selectedTab, true);
    }

    public static void render(CreativeScreen screen, MatrixStack pose) {
        if (maxCategoryTabPages == 0) {
            return;
        }
        ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (buttonPreviousCategoryPage == null || buttonNextCategoryPage == null) {
            return;
        }
        if (!CreativeScreenHandler.buttonPreviousCategoryPage.field_230694_p_) {
            return;
        }
        Minecraft minecraft = screen.getMinecraft();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        FontRenderer font = minecraft.field_71466_p;
        RenderSystem.disableLighting();
        screen.func_230926_e_(300);
        itemRenderer.field_77023_b = 300.0f;
        int maxLineWidth = 6;
        int x = CreativeScreenHandler.buttonPreviousCategoryPage.field_230690_l_ + (buttonPreviousCategoryPage.func_230998_h_() / 2 - maxLineWidth / 2);
        int fontColor = buttonPreviousCategoryPage.getFGColor();
        int nextY = CreativeScreenHandler.buttonNextCategoryPage.field_230691_m_;
        int nextHeight = buttonNextCategoryPage.func_238483_d_();
        int previousY = CreativeScreenHandler.buttonPreviousCategoryPage.field_230691_m_;
        int previousHeight = buttonPreviousCategoryPage.func_238483_d_();
        float yTop = previousY + previousHeight;
        float yBottom = nextY;
        float yDist = yBottom - yTop;
        font.getClass();
        float y = yTop - 9.0f / 2.0f + yDist / 2.0f;
        String string = "" + (categoryTabPage + 1);
        float f = x;
        font.getClass();
        font.func_238405_a_(pose, string, f, y - 9.0f, fontColor);
        font.func_238405_a_(pose, "/", (float)x, y, fontColor);
        String string2 = "" + (maxCategoryTabPages + 1);
        float f2 = x;
        font.getClass();
        font.func_238405_a_(pose, string2, f2, y + 9.0f, fontColor);
        screen.func_230926_e_(0);
        itemRenderer.field_77023_b = 0.0f;
    }

    private static void renderTabButton(CreativeScreen screen, MatrixStack pose, ItemGroup itemGroup, boolean enabled) {
        if (!CreativeScreenHandler.isSupportedTab(itemGroup)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, itemGroup)) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(itemGroup);
        Minecraft minecraft = screen.getMinecraft();
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        TextureManager textureManager = minecraft.func_110434_K();
        int tabIndex = 0;
        int tabsInteracted = 0;
        for (ItemGroupCategory category : manager.getCategories()) {
            if (tabsInteracted >= 4) break;
            if (manager.isCategoryEnabled(category)) {
                if (!enabled) {
                    ++tabIndex;
                    continue;
                }
            } else if (enabled) {
                ++tabIndex;
                continue;
            }
            if (categoryTabPage == CreativeScreenHandler.getTabPage(tabIndex)) {
                int u = CreativeScreenHandler.getTabU(manager, category);
                int x = CreativeScreenHandler.getTabX(screen);
                int y = CreativeScreenHandler.getTabY(screen, tabIndex);
                textureManager.func_110577_a(CATEGORY_TABS_TEXTURE);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                AbstractGui.func_238464_a_((MatrixStack)pose, (int)x, (int)y, (int)screen.func_230927_p_(), (float)u, (float)0.0f, (int)32, (int)28, (int)28, (int)64);
                itemRenderer.field_77023_b = 100.0f;
                RenderSystem.enableRescaleNormal();
                int iconX = x + 8;
                int iconY = y + 6;
                ItemStack icon = category.getCategoryIcon(itemGroup);
                itemRenderer.func_180450_b(icon, iconX, iconY);
                itemRenderer.func_175030_a(minecraft.field_71466_p, icon, iconX, iconY);
                itemRenderer.field_77023_b = 0.0f;
                ++tabsInteracted;
            }
            ++tabIndex;
        }
    }

    public static void mouseClicked(CreativeScreen screen, double mouseX, double mouseY, int mouseButton, CallbackInfoReturnable<Boolean> cir) {
        ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, selectedTab)) {
            return;
        }
        if (mouseButton != 0) {
            return;
        }
        Set<ItemGroupCategory> categories = ItemGroupCategoryManager.getInstance(selectedTab).getCategories();
        int tabsInteracted = 0;
        for (int tabIndex = 0; tabIndex < categories.size() && tabsInteracted < 4; ++tabIndex) {
            if (categoryTabPage != CreativeScreenHandler.getTabPage(tabIndex)) continue;
            int x = CreativeScreenHandler.getTabX(screen);
            int y = CreativeScreenHandler.getTabY(screen, tabIndex);
            if (mouseX >= (double)x && mouseX <= (double)(x + 32) && mouseY >= (double)y && mouseY <= (double)(y + 28)) {
                cir.setReturnValue((Object)true);
                return;
            }
            ++tabsInteracted;
        }
    }

    public static void mouseReleased(CreativeScreen screen, double mouseX, double mouseY, int mouseButton, Consumer<Float> scrollOffsModifier, CallbackInfoReturnable<Boolean> cir) {
        ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (mouseButton != 0) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(selectedTab);
        int tabIndex = 0;
        int tabsInteracted = 0;
        for (ItemGroupCategory category : manager.getCategories()) {
            if (tabsInteracted >= 4) break;
            if (categoryTabPage == CreativeScreenHandler.getTabPage(tabIndex)) {
                int tabX = CreativeScreenHandler.getTabX(screen);
                int tabY = CreativeScreenHandler.getTabY(screen, tabIndex);
                if (mouseX >= (double)tabX && mouseX <= (double)(tabX + 32) && mouseY >= (double)tabY && mouseY <= (double)(tabY + 28)) {
                    CreativeScreen.CreativeContainer menu = (CreativeScreen.CreativeContainer)screen.func_212873_a_();
                    manager.toggleCategory(category);
                    manager.applyFilter((NonNullList<ItemStack>)menu.field_148330_a);
                    menu.func_148329_a(0.0f);
                    scrollOffsModifier.accept(Float.valueOf(0.0f));
                    cir.setReturnValue((Object)true);
                    return;
                }
                ++tabsInteracted;
            }
            ++tabIndex;
        }
    }

    public static void checkTabHovering(CreativeScreen screen, MatrixStack pose, ItemGroup itemGroup, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (!CreativeScreenHandler.isSupportedTab(itemGroup)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, itemGroup)) {
            return;
        }
        ItemGroupCategoryManager manager = ItemGroupCategoryManager.getInstance(itemGroup);
        int tabIndex = 0;
        int tabsInteracted = 0;
        for (ItemGroupCategory category : manager.getCategories()) {
            if (tabsInteracted >= 4) break;
            if (categoryTabPage == CreativeScreenHandler.getTabPage(tabIndex)) {
                int tabX = CreativeScreenHandler.getTabX(screen);
                int tabY = CreativeScreenHandler.getTabY(screen, tabIndex);
                if (mouseX >= tabX && mouseX <= tabX + 32 && mouseY >= tabY && mouseY <= tabY + 28) {
                    ITextComponent categoryName = category.getCategoryName();
                    screen.func_238652_a_(pose, categoryName, mouseX, mouseY);
                    cir.setReturnValue((Object)true);
                    return;
                }
                ++tabsInteracted;
            }
            ++tabIndex;
        }
    }

    public static void tick(CreativeScreen screen, int tabPage) {
        if (screen.getMinecraft().field_71442_b != null && !screen.getMinecraft().field_71442_b.func_78758_h()) {
            return;
        }
        ItemGroup selectedTab = CreativeScreenHandler.getSelectedTab(screen);
        CreativeScreenHandler.updateButtonState(screen, selectedTab, tabPage, true);
        CreativeScreenHandler.updateButtonState(screen, selectedTab, tabPage, false);
        if (!CreativeScreenHandler.isSupportedTab(selectedTab)) {
            return;
        }
        if (!CreativeScreenHandler.isSelectedTab(screen, selectedTab)) {
            return;
        }
        boolean cycleIcons = !Screen.func_231173_s_();
        ItemGroupCategoryManager.getInstance(selectedTab).getCategories().forEach(c -> c.tick(cycleIcons));
    }

    public static boolean checkEffectRendering(CreativeScreen screen, MatrixStack pose, int leftPos) {
        ItemGroupCategoryManager manager;
        ItemGroup itemGroup;
        Minecraft mc = screen.getMinecraft();
        if (mc.field_71439_g != null && CreativeScreenHandler.isSupportedTab(itemGroup = CreativeScreenHandler.getSelectedTab(screen)) && !(manager = ItemGroupCategoryManager.getInstance(itemGroup)).getCategories().isEmpty()) {
            Collection effects = mc.field_71439_g.func_70651_bq();
            if (!effects.isEmpty()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int effectCount = effects.size();
                int renderX = leftPos - 150;
                int renderY = 33;
                if (effectCount > 5) {
                    renderY = 132 / (effectCount - 1);
                }
                Iterable effectsToRender = effects.stream().filter(IForgeEffectInstance::shouldRender).sorted().collect(Collectors.toList());
                CreativeScreenHandler.renderEffectBackgrounds(screen, pose, renderX, renderY, effectsToRender);
                CreativeScreenHandler.renderEffectIcons(screen, pose, renderX, renderY, effectsToRender);
                CreativeScreenHandler.renderEffectLabels(screen, pose, renderX, renderY, effectsToRender);
            }
            return true;
        }
        return false;
    }

    private static void updateButtonState(CreativeScreen screen, @Nullable ItemGroup selectedTab, int tabPage, boolean isNext) {
        boolean isVisible = false;
        boolean isActive = false;
        if (maxCategoryTabPages > 0 && CreativeScreenHandler.isSupportedTab(selectedTab) && CreativeScreenHandler.isSelectedTab(screen, selectedTab) && tabPage == selectedTab.getTabPage()) {
            isVisible = true;
            if (isNext) {
                if (categoryTabPage <= maxCategoryTabPages - 1) {
                    isActive = true;
                }
            } else if (categoryTabPage - 1 >= 0) {
                isActive = true;
            }
        }
        if (!isVisible) {
            isActive = false;
        }
        if (isActive) {
            isVisible = true;
        }
        if (isNext) {
            if (buttonNextCategoryPage != null) {
                CreativeScreenHandler.buttonNextCategoryPage.field_230694_p_ = isVisible;
                CreativeScreenHandler.buttonNextCategoryPage.field_230693_o_ = isActive;
            }
        } else if (buttonPreviousCategoryPage != null) {
            CreativeScreenHandler.buttonPreviousCategoryPage.field_230694_p_ = isVisible;
            CreativeScreenHandler.buttonPreviousCategoryPage.field_230693_o_ = isActive;
        }
    }

    private static int getTabPage(int tabIndex) {
        if (tabIndex < 4) {
            return 0;
        }
        return (tabIndex - 4) / 2 + 1;
    }

    private static int getTabU(ItemGroupCategoryManager manager, ItemGroupCategory category) {
        return manager.isCategoryEnabled(category) ? 32 : 0;
    }

    private static int getTabX(CreativeScreen screen) {
        return screen.getGuiLeft() - 32 + 4;
    }

    private static int getTabY(CreativeScreen screen, int tabIndex) {
        int offset = tabIndex % 4 * 28;
        return screen.getGuiTop() + offset + 12;
    }

    @Nullable
    private static ItemGroup getSelectedTab(CreativeScreen screen) {
        int selectedTab = screen.func_147056_g();
        if (selectedTab == -1) {
            return null;
        }
        return ItemGroup.field_78032_a[selectedTab];
    }

    private static boolean isSelectedTab(CreativeScreen screen, ItemGroup itemGroup) {
        return screen.func_147056_g() == itemGroup.func_78021_a();
    }

    private static boolean isSupportedTab(@Nullable ItemGroup itemGroup) {
        if (itemGroup == null) {
            return false;
        }
        if (CreativeScreenHandler.matches(itemGroup, ItemGroup.field_78036_m)) {
            return false;
        }
        if (CreativeScreenHandler.matches(itemGroup, ItemGroup.field_192395_m)) {
            return false;
        }
        if (CreativeScreenHandler.matches(itemGroup, ItemGroup.field_78027_g)) {
            return false;
        }
        return !ItemGroupCategoryManager.getInstance(itemGroup).getCategories().isEmpty();
    }

    private static boolean matches(ItemGroup a, ItemGroup b) {
        return a.func_78021_a() == b.func_78021_a();
    }

    private static void renderEffectBackgrounds(CreativeScreen screen, MatrixStack pose, int renderX, int renderY, Iterable<EffectInstance> effects) {
        screen.getMinecraft().field_71446_o.func_110577_a(ContainerScreen.field_147001_a);
        int i = screen.getGuiTop();
        for (EffectInstance effect : effects) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.func_238474_b_(pose, renderX, i, 0, 166, 140, 32);
            i += renderY;
        }
    }

    private static void renderEffectIcons(CreativeScreen screen, MatrixStack pose, int renderX, int renderY, Iterable<EffectInstance> effects) {
        Minecraft mc = screen.getMinecraft();
        PotionSpriteUploader spriteUploader = mc.func_213248_ap();
        int i = screen.getGuiTop();
        int blitOffset = screen.func_230927_p_();
        for (EffectInstance instance : effects) {
            Effect effect = instance.func_188419_a();
            TextureAtlasSprite sprite = spriteUploader.func_215288_a(effect);
            mc.field_71446_o.func_110577_a(sprite.func_229241_m_().func_229223_g_());
            AbstractGui.func_238470_a_((MatrixStack)pose, (int)(renderX + 6), (int)(i + 7), (int)blitOffset, (int)18, (int)18, (TextureAtlasSprite)sprite);
            i += renderY;
        }
    }

    private static void renderEffectLabels(CreativeScreen screen, MatrixStack pose, int renderX, int renderY, Iterable<EffectInstance> effects) {
        Minecraft mc = screen.getMinecraft();
        int i = screen.getGuiTop();
        int blitOffset = screen.func_230927_p_();
        for (EffectInstance effect : effects) {
            effect.renderInventoryEffect((DisplayEffectsScreen)screen, pose, renderX, i, (float)blitOffset);
            if (effect.shouldRenderInvText()) {
                String s = I18n.func_135052_a((String)effect.func_188419_a().func_76393_a(), (Object[])new Object[0]);
                int amplifier = effect.func_76458_c();
                if (amplifier >= 1 && amplifier <= 9) {
                    s = s + ' ' + I18n.func_135052_a((String)("enchantment.level." + (amplifier + 1)), (Object[])new Object[0]);
                }
                mc.field_71466_p.func_238405_a_(pose, s, (float)(renderX + 10 + 18), (float)(i + 6), 0xFFFFFF);
                s = EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f);
                mc.field_71466_p.func_238405_a_(pose, s, (float)(renderX + 10 + 18), (float)(i + 6 + 10), 0x7F7F7F);
            }
            i += renderY;
        }
    }
}

