/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;

public final class CommandApex {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"apexcore").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"supporters").then(Commands.func_197057_a((String)"arethey").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(CommandApex::onAreTheySupporting)))).then(Commands.func_197057_a((String)"ami").executes(CommandApex::onAmISupporting))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").requires(CommandApex::requiresOp)).executes(CommandApex::onReloadSupporters))));
    }

    private static boolean requiresOp(CommandSource src) {
        return src.func_197034_c(2);
    }

    private static int onReloadSupporters(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        src.func_197030_a((ITextComponent)new StringTextComponent("Reloading ").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent("ApexCore").func_240700_a_(style -> style.func_240713_a_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.AQUA))).func_230529_a_((ITextComponent)new StringTextComponent(" Supporters..").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN))), true);
        SupporterManager.loadSupporters();
        src.func_197030_a((ITextComponent)new StringTextComponent("Reloaded ").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent("ApexCore").func_240700_a_(style -> style.func_240713_a_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.AQUA))).func_230529_a_((ITextComponent)new StringTextComponent(" Supporters!").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN))), true);
        return 1;
    }

    private static int onAreTheySupporting(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = EntityArgument.func_197089_d(ctx, (String)"player");
        CommandSource src = (CommandSource)ctx.getSource();
        Entity entity = src.func_197022_f();
        if (entity instanceof PlayerEntity && CommandApex.areSamePlayers((PlayerEntity)player, (PlayerEntity)entity)) {
            return CommandApex.onAmISupporting((CommandContext<CommandSource>)ctx.copyFor((Object)src.func_197024_a((Entity)player)));
        }
        src.func_197030_a(CommandApex.buildSupporterComponent(player, false), true);
        return 1;
    }

    private static int onAmISupporting(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource src = (CommandSource)ctx.getSource();
        ServerPlayerEntity player = src.func_197035_h();
        src.func_197030_a(CommandApex.buildSupporterComponent(player, true), true);
        return 1;
    }

    private static ITextComponent buildSupporterComponent(ServerPlayerEntity player, boolean you) {
        IFormattableTextComponent supporting;
        Optional<SupporterManager.SupporterInfo> infoOpt = SupporterManager.findSupporterInfo((PlayerEntity)player);
        IFormattableTextComponent playerName = (you ? new StringTextComponent("You") : new StringTextComponent(player.func_145748_c_().getString())).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240713_a_(Boolean.valueOf(true)));
        IFormattableTextComponent apexStudios = new StringTextComponent("ApexStudios").func_240700_a_(style -> style.func_240712_a_(TextFormatting.AQUA).func_240722_b_(Boolean.valueOf(true)).func_240713_a_(Boolean.valueOf(true)));
        if (infoOpt.isPresent()) {
            SupporterManager.SupporterInfo info = infoOpt.get();
            supporting = you ? new StringTextComponent(" are Supporting ") : new StringTextComponent(" is Supporting ");
            IFormattableTextComponent level = new StringTextComponent(" (").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240713_a_(Boolean.valueOf(true))).func_230529_a_((ITextComponent)new StringTextComponent(info.getLevel().func_176610_l()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.DARK_AQUA).func_240722_b_(Boolean.valueOf(true)).func_240713_a_(Boolean.valueOf(true)))).func_230529_a_((ITextComponent)new StringTextComponent(")"));
            apexStudios.func_230529_a_((ITextComponent)level);
        } else {
            supporting = (you ? new StringTextComponent(" are Not Supporting ") : new StringTextComponent(" is Not Supporting ")).func_240700_a_(style -> style.func_240712_a_(TextFormatting.RED));
        }
        return playerName.func_230529_a_((ITextComponent)supporting).func_230529_a_((ITextComponent)apexStudios);
    }

    private static boolean areSamePlayers(PlayerEntity left, PlayerEntity right) {
        return left.func_146103_bH().getId().equals(right.func_146103_bH().getId());
    }
}

