/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.net;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.NetworkManager;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.java.utility.Apex;

public final class ClientSyncSupportersPacket
extends AbstractPacket {
    public final Set<SupporterManager.SupporterInfo> networkInfos;

    public ClientSyncSupportersPacket(Set<SupporterManager.SupporterInfo> networkInfos) {
        this.networkInfos = ImmutableSet.copyOf(networkInfos);
    }

    public ClientSyncSupportersPacket(PacketBuffer buffer) {
        super(buffer);
        int count = buffer.func_150792_a();
        this.networkInfos = Apex.makeImmutableSet(builder -> {
            for (int i = 0; i < count; ++i) {
                SupporterManager.SupporterLevel level = SupporterManager.SupporterLevel.DEFAULT;
                HashSet aliases = Sets.newHashSet();
                UUID playerId = buffer.func_179253_g();
                String username = buffer.func_218666_n();
                if (buffer.readBoolean()) {
                    level = (SupporterManager.SupporterLevel)buffer.func_179257_a(SupporterManager.SupporterLevel.class);
                }
                if (buffer.readBoolean()) {
                    int aliasCount = buffer.func_150792_a();
                    IntStream.range(0, aliasCount).mapToObj(j -> buffer.func_179253_g()).forEach(aliases::add);
                }
                builder.add((Object)new SupporterManager.SupporterInfo(playerId, level, aliases, username));
            }
            return builder;
        });
    }

    @Override
    protected void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.networkInfos.size());
        for (SupporterManager.SupporterInfo info : this.networkInfos) {
            SupporterManager.SupporterLevel level = info.getLevel();
            Set<UUID> aliases = info.getAliases();
            buffer.func_179252_a(info.getPlayerId());
            buffer.func_180714_a(info.getUsername());
            if (level.isDefault()) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.func_179249_a((Enum)level);
            }
            if (aliases.isEmpty()) {
                buffer.writeBoolean(false);
                continue;
            }
            buffer.writeBoolean(true);
            buffer.func_150787_b(aliases.size());
            aliases.forEach(arg_0 -> ((PacketBuffer)buffer).func_179252_a(arg_0));
        }
    }

    @Override
    protected void process(NetworkManager network, NetworkEvent.Context ctx) {
        SupporterManager.loadSupportersFromNetwork(this);
    }
}

