/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.java.utility.Lazy;
import xyz.apex.java.utility.nullness.NonnullPredicate;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;

public final class ItemGroupCategory
implements NonnullPredicate<ItemStack> {
    private static final int cycleTime = 1000;
    private final Builder builder;
    private final Map<ItemGroup, NonNullList<ItemStack>> categoryIcons = Maps.newHashMap();
    private long cycleStartTime;
    private long cycleTickTime;
    private long cyclePausedDuration = 0L;
    private final boolean cycleIcons;
    private final Lazy<ItemStack> defaultIcon;

    private ItemGroupCategory(Builder builder) {
        this.builder = builder;
        this.defaultIcon = Lazy.of(() -> builder.defaultIcon == null ? Items.field_221803_eL.func_190903_i() : (ItemStack)builder.defaultIcon.get());
        this.cycleIcons = builder.cycleIcons;
        this.cycleTickTime = System.currentTimeMillis();
        this.cycleStartTime = this.cycleTickTime - (long)builder.cycleOffset * 1000L;
    }

    private NonNullList<ItemStack> getCategoryIcons(ItemGroup itemGroup) {
        NonNullList itemGroupItems = NonNullList.func_191196_a();
        NonNullList icons = NonNullList.func_191196_a();
        itemGroup.func_78018_a(itemGroupItems);
        for (ItemStack stack : itemGroupItems) {
            if (!this.test(stack)) continue;
            icons.add((Object)stack);
        }
        ItemStack defaultIcon = (ItemStack)this.defaultIcon.get();
        if (icons.isEmpty()) {
            icons.add((Object)defaultIcon);
        } else {
            for (ItemStack icon : icons) {
                if (!ItemStack.func_179545_c((ItemStack)icon, (ItemStack)defaultIcon)) continue;
                return icons;
            }
            icons.add((Object)defaultIcon);
        }
        return icons;
    }

    public boolean test(ItemStack stack) {
        return this.builder.categoryPredicate.test((Object)stack);
    }

    public boolean isCyclingIcons() {
        return this.cycleIcons;
    }

    public void tick(boolean doCycle) {
        if (this.cycleIcons) {
            if (this.cycleIcons) {
                if (this.cyclePausedDuration > 0L) {
                    this.cycleStartTime += this.cyclePausedDuration;
                    this.cyclePausedDuration = 0L;
                }
                this.cycleTickTime = System.currentTimeMillis();
            } else {
                this.cyclePausedDuration = System.currentTimeMillis() - this.cycleTickTime;
            }
        }
    }

    public ItemStack getCategoryIcon(ItemGroup itemGroup) {
        if (this.cycleIcons) {
            List icons = (List)this.categoryIcons.computeIfAbsent(itemGroup, this::getCategoryIcons);
            if (icons.isEmpty()) {
                return (ItemStack)this.defaultIcon.get();
            }
            long index = (this.cycleTickTime - this.cycleStartTime) / 1000L % (long)icons.size();
            return (ItemStack)icons.get(Math.toIntExact(index));
        }
        return (ItemStack)this.defaultIcon.get();
    }

    public String getCategoryNameKey() {
        return "itemGroup.category." + this.builder.categoryName;
    }

    public ITextComponent getCategoryName() {
        String categoryNameKey = this.getCategoryNameKey();
        return new TranslationTextComponent(categoryNameKey);
    }

    public <T extends AbstractRegistrator<T>> ItemGroupCategory addTranslationGenerator(T registrator, String englishName) {
        registrator.addDataGenerator(ProviderType.LANG, provider -> provider.add(this.getCategoryNameKey(), englishName));
        return this;
    }

    public <T extends AbstractRegistrator<T>> ItemGroupCategory addTranslationGenerator(T registrator, String languageKey, String translationValue) {
        registrator.addDataGenerator(AbstractRegistrator.LANG_EXT_PROVIDER, provider -> provider.add(languageKey, this.getCategoryNameKey(), translationValue));
        return this;
    }

    public static Builder builder(String categoryName) {
        return new Builder(categoryName);
    }

    public static final class Builder {
        private final String categoryName;
        private int cycleOffset = (int)(Math.random() * 10000.0 % 2.147483647E9);
        private boolean cycleIcons = false;
        private NonnullPredicate<ItemStack> categoryPredicate = stack -> true;
        @Nullable
        private NonnullSupplier<ItemStack> defaultIcon;

        private Builder(String categoryName) {
            this.categoryName = categoryName;
        }

        public Builder predicate(NonnullPredicate<ItemStack> categoryPredicate) {
            this.categoryPredicate = categoryPredicate;
            return this;
        }

        public Builder defaultIcon(NonnullSupplier<ItemStack> defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public Builder tagged(ITag<Item> itemTag) {
            return this.predicate((NonnullPredicate<ItemStack>)((NonnullPredicate)s -> s.func_77973_b().func_206844_a(itemTag)));
        }

        public Builder cycleOffset(int cycleOffset) {
            this.cycleIcons = true;
            this.cycleOffset = cycleOffset;
            return this;
        }

        public Builder cycleIcons() {
            this.cycleIcons = true;
            return this;
        }

        public ItemGroupCategory build() {
            return new ItemGroupCategory(this);
        }
    }
}

