/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SingleItemRecipe
implements IRecipe<IInventory> {
    public static final String JSON_GROUP = "group";
    public static final String JSON_INGREDIENT = "ingredient";
    public static final String JSON_RESULT = "result";
    public static final String JSON_COUNT = "count";
    protected final Ingredient recipeIngredient;
    protected final ItemStack recipeResult;
    protected final ResourceLocation recipeId;
    protected final String recipeGroup;
    private final IRecipeType<?> recipeType;
    private final IRecipeSerializer<?> recipeSerializer;

    public SingleItemRecipe(IRecipeType<?> recipeType, IRecipeSerializer<?> recipeSerializer, ResourceLocation recipeId, String recipeGroup, Ingredient recipeIngredient, ItemStack recipeResult) {
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
        this.recipeId = recipeId;
        this.recipeGroup = recipeGroup;
        this.recipeIngredient = recipeIngredient;
        this.recipeResult = recipeResult;
    }

    public final IRecipeType<?> func_222127_g() {
        return this.recipeType;
    }

    public final IRecipeSerializer<?> func_199559_b() {
        return this.recipeSerializer;
    }

    public final ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public final String func_193358_e() {
        return this.recipeGroup;
    }

    public final ItemStack func_77571_b() {
        return this.recipeResult;
    }

    public final NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.recipeIngredient);
        return ingredients;
    }

    public final boolean func_194133_a(int width, int height) {
        return width + height >= 1;
    }

    public ItemStack func_77572_b(IInventory inventory) {
        return this.recipeResult.func_77946_l();
    }

    public boolean func_77569_a(IInventory inventory, World level) {
        return this.recipeIngredient.test(inventory.func_70301_a(0));
    }

    public static final class Serializer<T extends SingleItemRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IRecipeFactory<T> recipeFactory;

        public Serializer(IRecipeFactory<T> recipeFactory) {
            this.recipeFactory = recipeFactory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            String recipeGroup = JSONUtils.func_151219_a((JsonObject)json, (String)SingleItemRecipe.JSON_GROUP, (String)"");
            Ingredient recipeIngredient = JSONUtils.func_151202_d((JsonObject)json, (String)SingleItemRecipe.JSON_INGREDIENT) ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)SingleItemRecipe.JSON_INGREDIENT)) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)SingleItemRecipe.JSON_INGREDIENT));
            String recipeResultName = JSONUtils.func_151200_h((JsonObject)json, (String)SingleItemRecipe.JSON_RESULT);
            int recipeResultCount = JSONUtils.func_151203_m((JsonObject)json, (String)SingleItemRecipe.JSON_COUNT);
            ItemStack recipeResult = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(recipeResultName)), recipeResultCount);
            return this.recipeFactory.create(recipeId, recipeGroup, recipeIngredient, recipeResult);
        }

        public T fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String recipeGroup = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient recipeIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack recipeResult = buffer.func_150791_c();
            return this.recipeFactory.create(recipeId, recipeGroup, recipeIngredient, recipeResult);
        }

        public void toNetwork(PacketBuffer buffer, T recipe) {
            buffer.func_180714_a(((SingleItemRecipe)recipe).recipeGroup);
            ((SingleItemRecipe)recipe).recipeIngredient.func_199564_a(buffer);
            buffer.func_150788_a(((SingleItemRecipe)recipe).recipeResult);
        }

        @FunctionalInterface
        public static interface IRecipeFactory<T extends SingleItemRecipe> {
            public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
        }
    }
}

