/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util;

import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class ContainerHelper {
    public static int getRedstoneSignalFromContainer(IBlockReader level, BlockPos pos) {
        TileEntity blockEntity = level.func_175625_s(pos);
        return ContainerHelper.getRedstoneSignalFromContainer(blockEntity);
    }

    public static int getRedstoneSignalFromContainer(@Nullable TileEntity blockEntity) {
        if (blockEntity == null) {
            return 0;
        }
        if (blockEntity instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)blockEntity));
        }
        if (blockEntity instanceof IItemHandler) {
            return ContainerHelper.getRedstoneSignalFromContainer((IItemHandler)blockEntity);
        }
        return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(ContainerHelper::getRedstoneSignalFromContainer).orElse(0);
    }

    public static int getRedstoneSignalFromContainer(@Nullable IItemHandler itemHandler) {
        if (itemHandler == null) {
            return 0;
        }
        float f = 0.0f;
        int counter = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            f += (float)stack.func_190916_E() / (float)Math.min(itemHandler.getSlotLimit(i), stack.func_77976_d());
            ++counter;
        }
        return MathHelper.func_76141_d((float)((f /= (float)itemHandler.getSlots()) * 14.0f)) + (counter > 0 ? 1 : 0);
    }
}

