/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import xyz.apex.forge.apexcore.lib.util.ProfileHelper;

public final class SkinHelper {
    private static final SkinHelper INSTANCE = new SkinHelper();
    private final Cache<String, ResourceLocation> skinCache = CacheBuilder.newBuilder().expireAfterAccess(14L, TimeUnit.MINUTES).build();
    private final Cache<String, Set<Consumer<ResourceLocation>>> callbackMap = CacheBuilder.newBuilder().expireAfterWrite(12L, TimeUnit.SECONDS).build();
    private final Map<String, Boolean> slimCache = Collections.synchronizedMap(Maps.newHashMap());
    private final Map<UUID, Boolean> slimCacheUUID = Collections.synchronizedMap(Maps.newHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSkins0(@Nullable UUID playerId, String playerName, Consumer<ResourceLocation> callback) {
        NetworkPlayerInfo playerInfo;
        ResourceLocation skinLocation = (ResourceLocation)this.skinCache.getIfPresent((Object)playerName);
        if (skinLocation != null) {
            callback.accept(skinLocation);
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayNetHandler connection = mc.func_147114_u();
        NetworkPlayerInfo networkPlayerInfo = playerInfo = connection == null ? null : connection.func_175104_a(playerName);
        if (playerInfo != null && (skinLocation = playerInfo.func_178837_g()) != DefaultPlayerSkin.func_177334_a((UUID)playerInfo.func_178845_a().getId())) {
            callback.accept(skinLocation);
            this.skinCache.put((Object)playerName, (Object)skinLocation);
            return;
        }
        if (playerId == null) {
            return;
        }
        Cache<String, Set<Consumer<ResourceLocation>>> cache = this.callbackMap;
        synchronized (cache) {
            Set consumers = (Set)this.callbackMap.getIfPresent((Object)playerName);
            if (consumers == null) {
                GameProfile profile = ProfileHelper.getGameProfile(playerId, playerName);
                mc.func_152342_ad().func_152790_a(profile, (type, location, profileTexture) -> {
                    if (type == MinecraftProfileTexture.Type.SKIN) {
                        Cache<String, Set<Consumer<ResourceLocation>>> cache = this.callbackMap;
                        synchronized (cache) {
                            String model = profileTexture.getMetadata("model");
                            boolean isSlim = model != null && model.equals("slim");
                            this.slimCache.put(playerName, isSlim);
                            this.slimCacheUUID.put(playerId, isSlim);
                            Set consumerSet = (Set)this.callbackMap.getIfPresent((Object)playerName);
                            if (consumerSet != null) {
                                consumerSet.forEach(consumer -> consumer.accept(location));
                            }
                            this.callbackMap.invalidate((Object)playerName);
                            this.callbackMap.cleanUp();
                        }
                        this.skinCache.put((Object)playerName, (Object)location);
                    }
                }, true);
                HashSet set = Sets.newHashSet();
                set.add(callback);
                this.callbackMap.put((Object)playerName, (Object)set);
            } else {
                consumers.add(callback);
            }
        }
    }

    public static void getSkins(@Nullable UUID playerId, String playerName, Consumer<ResourceLocation> callback) {
        INSTANCE.getSkins0(playerId, playerName, callback);
    }

    public static boolean isSlim(@Nullable UUID playerId, String playerName) {
        if (SkinHelper.INSTANCE.slimCache.containsKey(playerName) && SkinHelper.INSTANCE.slimCache.get(playerName).booleanValue()) {
            return true;
        }
        return playerId != null && SkinHelper.INSTANCE.slimCacheUUID.containsKey(playerId) && SkinHelper.INSTANCE.slimCacheUUID.get(playerId) != false;
    }

    public static void invalidateCaches() {
        SkinHelper.INSTANCE.skinCache.invalidateAll();
        SkinHelper.INSTANCE.skinCache.cleanUp();
        SkinHelper.INSTANCE.callbackMap.invalidateAll();
        SkinHelper.INSTANCE.callbackMap.cleanUp();
        SkinHelper.INSTANCE.slimCache.clear();
        SkinHelper.INSTANCE.slimCacheUUID.clear();
    }
}

