/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.revamp.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.apex.forge.apexcore.lib.util.INameableMutable;
import xyz.apex.forge.apexcore.revamp.block.entity.BaseBlockEntity;

public abstract class InventoryBlockEntity
extends BaseBlockEntity
implements INameableMutable {
    public static final String NBT_CUSTOM_NAME = "CustomName";
    public static final String NBT_INVENTORY = "Inventory";
    @Nullable
    private ITextComponent customName;
    protected final ItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> itemHandlerCapability = LazyOptional.of(this::getItemHandler);

    protected InventoryBlockEntity(TileEntityType<? extends InventoryBlockEntity> blockEntityType, int slotCount) {
        super(blockEntityType);
        this.itemHandler = new ItemStackHandler(slotCount);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public CompoundNBT serializeData() {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_218657_a(NBT_INVENTORY, (INBT)this.serializeInventory());
        if (this.customName != null) {
            tagCompound.func_74778_a(NBT_CUSTOM_NAME, ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return tagCompound;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void deserializeData(CompoundNBT tagCompound) {
        if (tagCompound.func_150297_b(NBT_INVENTORY, 10)) {
            this.deserializeInventory(tagCompound.func_74775_l(NBT_INVENTORY));
        }
        if (tagCompound.func_150297_b(NBT_CUSTOM_NAME, 8)) {
            this.setCustomName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)tagCompound.func_74779_i(NBT_CUSTOM_NAME)));
        }
    }

    @OverridingMethodsMustInvokeSuper
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @OverridingMethodsMustInvokeSuper
    public void func_145843_s() {
        this.itemHandlerCapability.invalidate();
        super.func_145843_s();
    }

    public final IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    private CompoundNBT serializeInventory() {
        return this.itemHandler.serializeNBT();
    }

    private void deserializeInventory(CompoundNBT tagCompound) {
        this.itemHandler.deserializeNBT(tagCompound);
        this.func_70296_d();
    }

    public void writeContainerSyncData(PacketBuffer buffer) {
    }

    public void readContainerSyncData(PacketBuffer buffer) {
    }

    public final ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    @Nullable
    public final ITextComponent func_200201_e() {
        return this.customName;
    }

    @Override
    public final void setCustomName(@Nullable ITextComponent customName) {
        this.customName = customName;
        this.func_70296_d();
    }

    public final boolean func_145818_k_() {
        return this.customName != null;
    }

    public final ITextComponent func_145748_c_() {
        return this.customName == null ? this.func_200200_C_() : this.customName;
    }
}

