/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.infusedfoods.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import xyz.apex.forge.infusedfoods.InfusedFoods;
import xyz.apex.forge.infusedfoods.block.entity.InfusionStationBlockEntity;
import xyz.apex.forge.infusedfoods.container.InfusionStationMenu;
import xyz.apex.forge.infusedfoods.init.IFElements;

public final class InfusionStationMenuScreen
extends AbstractContainerScreen<InfusionStationMenu> {
    public InfusionStationMenuScreen(InfusionStationMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7856_() {
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        super.m_7856_();
        this.f_97728_ = this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_) - 8;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(pose);
        super.m_6305_(pose, mouseX, mouseY, partialTick);
        this.renderSlotBackground(pose, 1, 240, 0);
        this.renderSlotBackground(pose, 0, 240, 16);
        this.renderSlotBackground(pose, 2, 240, 33);
        this.renderInfusionFluid(pose);
        this.renderInfusionProgress(pose);
        this.renderInfusionFluidTankOverlay(pose, mouseX, mouseY);
        this.m_7025_(pose, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack pose, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(pose, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void renderSlotBackground(PoseStack pose, int slotIndex, int backgroundX, int backgroundY) {
        Slot slot = ((InfusionStationMenu)this.f_97732_).m_38853_(slotIndex);
        if (!slot.m_6657_()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
            InfusionStationMenuScreen.m_93133_((PoseStack)pose, (int)(this.f_97735_ + slot.f_40220_), (int)(this.f_97736_ + slot.f_40221_), (float)backgroundX, (float)backgroundY, (int)16, (int)16, (int)256, (int)256);
        }
    }

    private void renderInfusionFluidTankOverlay(PoseStack pose, int mouseX, int mouseY) {
        int tankWidth = 16;
        int tankHeight = 40;
        int tankX = this.f_97735_ + 8;
        int tankY = this.f_97736_ + 8;
        RenderSystem.m_157456_((int)0, (ResourceLocation)IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
        InfusionStationMenuScreen.m_93133_((PoseStack)pose, (int)tankX, (int)tankY, (float)176.0f, (float)41.0f, (int)tankWidth, (int)tankHeight, (int)256, (int)256);
        if (mouseX >= tankX && mouseY >= tankY && mouseX < tankX + tankWidth && mouseY < tankY + tankHeight) {
            this.m_93179_(pose, tankX, tankY, tankX + tankWidth, tankY + tankHeight, -2130706433, -2130706433);
            MobEffect effect = ((InfusionStationMenu)this.f_97732_).blockEntity.getEffect();
            if (effect != null) {
                ArrayList tooltip = Lists.newArrayList();
                InfusedFoods.appendPotionEffectTooltips(effect, ((InfusionStationMenu)this.f_97732_).blockEntity.getEffectAmplifier(), ((InfusionStationMenu)this.f_97732_).blockEntity.getEffectDuration(), tooltip);
                this.m_169388_(pose, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private void renderInfusionFluid(PoseStack pose) {
        MobEffect effect = ((InfusionStationMenu)this.f_97732_).blockEntity.getEffect();
        if (effect != null) {
            int tankWidth = 16;
            int tankHeight = 40;
            int tankX = this.f_97735_ + 8;
            int tankY = this.f_97736_ + tankHeight;
            int fluidWidth = 16;
            int fluidHeight = 8;
            int fluidAmount = ((InfusionStationMenu)this.f_97732_).blockEntity.getEffectAmount();
            int color = InfusionStationBlockEntity.getColor(effect, ((InfusionStationMenu)this.f_97732_).blockEntity.getEffectAmplifier());
            RenderSystem.m_157456_((int)0, (ResourceLocation)IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
            for (int i = 0; i < fluidAmount; ++i) {
                InfusionStationMenuScreen.m_93133_((PoseStack)pose, (int)tankX, (int)(tankY - i * fluidHeight), (float)176.0f, (float)33.0f, (int)fluidWidth, (int)fluidHeight, (int)256, (int)256);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderInfusionProgress(PoseStack pose) {
        int j1;
        RenderSystem.m_157456_((int)0, (ResourceLocation)IFElements.INFUSION_STATION_CONTAINER_SCREEN_TEXTURE);
        int blazeFuel = ((InfusionStationMenu)this.f_97732_).blockEntity.getBlazeFuel();
        int infuseTime = ((InfusionStationMenu)this.f_97732_).blockEntity.getInfuseTime();
        int blazeWidth = Mth.m_14045_((int)((18 * blazeFuel + 20 - 1) / 20), (int)0, (int)18);
        if (blazeWidth > 0) {
            InfusionStationMenuScreen.m_93133_((PoseStack)pose, (int)(this.f_97735_ + 89), (int)(this.f_97736_ + 72), (float)176.0f, (float)29.0f, (int)blazeWidth, (int)4, (int)256, (int)256);
        }
        if (infuseTime > 0 && (j1 = (int)(28.0f * (1.0f - (float)infuseTime / 400.0f))) > 0) {
            InfusionStationMenuScreen.m_93133_((PoseStack)pose, (int)(this.f_97735_ + 106), (int)(this.f_97736_ + 25), (float)189.0f, (float)0.0f, (int)j1, (int)9, (int)256, (int)256);
            InfusionStationMenuScreen.m_93133_((PoseStack)pose, (int)(this.f_97735_ + 92), (int)(this.f_97736_ + 42 + 29 - j1), (float)176.0f, (float)(29 - j1), (int)13, (int)j1, (int)256, (int)256);
        }
    }
}

