/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.DistExecutor;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.BlockEntityBuilder;
import xyz.apex.forge.utility.registrator.builder.ItemBuilder;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.factory.BlockEntityFactory;
import xyz.apex.forge.utility.registrator.factory.BlockFactory;
import xyz.apex.forge.utility.registrator.factory.item.BlockItemFactory;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class BlockBuilder<OWNER extends AbstractRegistrator<OWNER>, BLOCK extends Block, PARENT>
extends RegistratorBuilder<OWNER, Block, BLOCK, PARENT, BlockBuilder<OWNER, BLOCK, PARENT>, BlockEntry<BLOCK>> {
    private final BlockFactory<BLOCK> blockFactory;
    private NonnullSupplier<BlockBehaviour.Properties> initialProperties;
    private NonnullUnaryOperator<BlockBehaviour.Properties> propertiesModifier = NonnullUnaryOperator.identity();
    private final List<NonnullSupplier<NonnullSupplier<RenderType>>> renderTypes = Lists.newArrayList();
    @Nullable
    private NonnullSupplier<NonnullSupplier<BlockColor>> colorHandler = null;
    @Nullable
    private ItemBuilder<OWNER, ?, BlockBuilder<OWNER, BLOCK, PARENT>> itemBuilder = null;
    @Nullable
    private BlockEntityBuilder<OWNER, ?, BlockBuilder<OWNER, BLOCK, PARENT>> blockEntityBuilder = null;

    public BlockBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, BlockFactory<BLOCK> blockFactory, NonnullSupplier<BlockBehaviour.Properties> initialProperties) {
        super(owner, parent, registryName, callback, Block.class, BlockEntry::new, BlockEntry::cast);
        this.blockFactory = blockFactory;
        this.initialProperties = initialProperties;
        this.onRegister(this::onRegister);
        this.defaultBlockState().defaultLoot().defaultLang();
    }

    private void onRegister(BLOCK block) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            OneTimeEventReceiver.addModListener(ColorHandlerEvent.Block.class, event -> this.registerBlockColor((ColorHandlerEvent.Block)event, block));
            this.registerRenderTypes(block);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColor(ColorHandlerEvent.Block event, BLOCK block) {
        if (this.colorHandler != null) {
            event.getBlockColors().m_92589_(this.colorHandler.get().get(), new Block[]{block});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderTypes(BLOCK block) {
        if (this.renderTypes.size() == 1) {
            RenderType renderType = this.renderTypes.get(0).get().get();
            ItemBlockRenderTypes.setRenderLayer(block, (RenderType)renderType);
        } else if (this.renderTypes.size() > 1) {
            ImmutableSet renderTypes = (ImmutableSet)this.renderTypes.stream().map(NonnullSupplier::get).map(NonnullSupplier::get).collect(ImmutableSet.toImmutableSet());
            ItemBlockRenderTypes.setRenderLayer(block, arg_0 -> ((ImmutableSet)renderTypes).contains(arg_0));
        }
    }

    @Override
    @NonnullType
    protected BLOCK createEntry() {
        if (this.itemBuilder != null) {
            this.copyMappingsTo(this.itemBuilder);
        }
        if (this.blockEntityBuilder != null) {
            this.copyMappingsTo(this.blockEntityBuilder);
        }
        BlockBehaviour.Properties properties = this.initialProperties.get();
        properties = (BlockBehaviour.Properties)this.propertiesModifier.apply(properties);
        return this.blockFactory.create(properties);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> properties(NonnullUnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60939_((Material)material);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, DyeColor materialColor) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60941_((Material)material, (DyeColor)materialColor);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, MaterialColor materialColor) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)materialColor);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, NonnullFunction<BlockState, MaterialColor> materialColorFactory) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60947_((Material)material, (Function)materialColorFactory);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(NonnullSupplier<? extends Block> block) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()));
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> noCollission() {
        return this.properties(BlockBehaviour.Properties::m_60910_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> noOcclusion() {
        return this.properties(BlockBehaviour.Properties::m_60955_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> friction(float friction) {
        return this.properties(properties -> properties.m_60911_(friction));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> speedFactor(float speedFactor) {
        return this.properties(properties -> properties.m_60956_(speedFactor));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> jumpFactor(float jumpFactor) {
        return this.properties(properties -> properties.m_60967_(jumpFactor));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> sound(SoundType soundType) {
        return this.properties(properties -> properties.m_60918_(soundType));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> lightLevel(ToIntFunction<BlockState> lightLevelFunction) {
        return this.properties(properties -> properties.m_60953_(lightLevelFunction));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> strength(float destroyTime, float explosionResistance) {
        return this.properties(properties -> properties.m_60913_(destroyTime, explosionResistance));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> instabreak() {
        return this.properties(BlockBehaviour.Properties::m_60966_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> strength(float strength) {
        return this.properties(properties -> properties.m_60978_(strength));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> randomTicks() {
        return this.properties(BlockBehaviour.Properties::m_60977_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> dynamicShape() {
        return this.properties(BlockBehaviour.Properties::m_60988_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> noDrops() {
        return this.properties(BlockBehaviour.Properties::m_60993_);
    }

    @Deprecated
    public BlockBuilder<OWNER, BLOCK, PARENT> dropsLike(Block block) {
        return this.properties(properties -> properties.m_60916_(block));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> dropsLike(NonnullSupplier<? extends Block> block) {
        return this.properties(properties -> properties.lootFrom((Supplier)block));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> air() {
        return this.properties(BlockBehaviour.Properties::m_60996_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> extendedPositionPredicate) {
        return this.properties(properties -> properties.m_60922_(extendedPositionPredicate));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isRedstoneConductor(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60924_(positionPredicate));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isSuffocating(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60960_(positionPredicate));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isViewBlocking(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60971_(positionPredicate));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> hasPostProcess(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60982_(positionPredicate));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> emissiveRendering(BlockBehaviour.StatePredicate positionPredicate) {
        return this.properties(properties -> properties.m_60991_(positionPredicate));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> requiresCorrectToolForDrops() {
        return this.properties(BlockBehaviour.Properties::m_60999_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> color(MaterialColor materialColor) {
        return this.properties(properties -> properties.m_155949_(materialColor));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> destroyTime(float destroyTime) {
        return this.properties(properties -> properties.m_155954_(destroyTime));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> explosionResistance(float explosionResistance) {
        return this.properties(properties -> properties.m_155956_(explosionResistance));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> addRenderType(NonnullSupplier<NonnullSupplier<RenderType>> renderType) {
        this.renderTypes.add(renderType);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> simpleItem() {
        return this.simpleItem(BlockItemFactory.forBlock());
    }

    public <ITEM extends BlockItem> BlockBuilder<OWNER, BLOCK, PARENT> simpleItem(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        return (BlockBuilder)this.item(blockItemFactory).build();
    }

    public ItemBuilder<OWNER, BlockItem, BlockBuilder<OWNER, BLOCK, PARENT>> item() {
        return this.item(BlockItemFactory.forBlock());
    }

    public <ITEM extends BlockItem> ItemBuilder<OWNER, ITEM, BlockBuilder<OWNER, BLOCK, PARENT>> item(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        if (this.itemBuilder == null) {
            this.itemBuilder = this.owner.blockItem(this.getName(), this, this.toSupplier(), blockItemFactory);
        }
        return this.itemBuilder;
    }

    public <BLOCK_ENTITY extends BlockEntity> BlockBuilder<OWNER, BLOCK, PARENT> simpleBlockEntity(BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        return (BlockBuilder)this.blockEntity(blockEntityFactory).build();
    }

    public <BLOCK_ENTITY extends BlockEntity> BlockEntityBuilder<OWNER, BLOCK_ENTITY, BlockBuilder<OWNER, BLOCK, PARENT>> blockEntity(BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        if (this.blockEntityBuilder == null) {
            this.blockEntityBuilder = this.owner.blockEntity(this.getName(), this, blockEntityFactory).validBlock(() -> (Block)this.asSupplier().get());
        }
        return this.blockEntityBuilder;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> color(NonnullSupplier<NonnullSupplier<BlockColor>> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> defaultBlockState() {
        return this.blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.getEntry()));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> blockState(NonnullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateBlockstateProvider> consumer) {
        return (BlockBuilder)this.setDataGenerator(ProviderType.BLOCKSTATE, consumer);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> defaultLang() {
        return (BlockBuilder)this.lang(Block::m_7705_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> lang(String name) {
        return (BlockBuilder)this.lang(Block::m_7705_, name);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> defaultLoot() {
        return this.loot(BlockLoot::m_124288_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> loot(NonnullBiConsumer<RegistrateBlockLootTables, BLOCK> consumer) {
        return (BlockBuilder)this.setDataGenerator(ProviderType.LOOT, (ctx, provider) -> provider.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, lootTables -> consumer.accept((RegistrateBlockLootTables)lootTables, (Object)((Block)ctx.getEntry()))));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> recipe(NonnullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateRecipeProvider> consumer) {
        return (BlockBuilder)this.setDataGenerator(ProviderType.RECIPE, consumer);
    }

    @SafeVarargs
    public final BlockBuilder<OWNER, BLOCK, PARENT> tag(Tag.Named<Block> ... tags) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @SafeVarargs
    public final BlockBuilder<OWNER, BLOCK, PARENT> removeTag(Tag.Named<Block> ... tags) {
        return (BlockBuilder)this.removeTag(ProviderType.BLOCK_TAGS, tags);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> lang(String languageKey, String localizedValue) {
        return (BlockBuilder)this.lang(languageKey, Block::m_7705_, localizedValue);
    }
}

