/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.tags.Tag;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.factory.BlockEntityFactory;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class BlockEntityBuilder<OWNER extends AbstractRegistrator<OWNER>, BLOCK_ENTITY extends BlockEntity, PARENT>
extends RegistratorBuilder<OWNER, BlockEntityType<?>, BlockEntityType<BLOCK_ENTITY>, PARENT, BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT>, BlockEntityEntry<BLOCK_ENTITY>> {
    private final BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory;
    private final Set<NonnullSupplier<? extends Block>> validBlocks = Sets.newHashSet();
    @Nullable
    private NonnullSupplier<NonnullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super BLOCK_ENTITY>>> renderer = null;

    public BlockEntityBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        super(owner, parent, registryName, callback, BlockEntityType.class, BlockEntityEntry::new, BlockEntityEntry::cast);
        this.blockEntityFactory = blockEntityFactory;
        this.onRegister(this::onRegister);
    }

    @Override
    private void onRegister(BlockEntityType<BLOCK_ENTITY> blockEntityType) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, event -> event.enqueueWork(() -> this.registerRenderer(blockEntityType))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderer(BlockEntityType<BLOCK_ENTITY> blockEntityType) {
        if (this.renderer != null) {
            BlockEntityRenderers.m_173590_(blockEntityType, this.renderer.get()::apply);
        }
    }

    @Override
    @NonnullType
    protected BlockEntityType<BLOCK_ENTITY> createEntry() {
        NonnullSupplier supplier = this.toSupplier();
        Block[] validBlocks = (Block[])this.validBlocks.stream().map(NonnullSupplier::get).toArray(Block[]::new);
        BlockEntityType.Builder builder = BlockEntityType.Builder.m_155273_((pos, blockState) -> this.blockEntityFactory.create((BlockEntityType)supplier.get(), pos, blockState), (Block[])validBlocks);
        return builder.m_58966_(Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)this.getRegistryNameFull()));
    }

    public BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> validBlock(NonnullSupplier<? extends Block> block) {
        this.validBlocks.add(block);
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> validBlocks(NonnullSupplier<? extends Block> ... blocks) {
        Collections.addAll(this.validBlocks, blocks);
        return this;
    }

    public BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> renderer(NonnullSupplier<NonnullFunction<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super BLOCK_ENTITY>>> renderer) {
        this.renderer = renderer;
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> tag(Tag.Named<BlockEntityType<?>> ... tags) {
        return (BlockEntityBuilder)this.tag(AbstractRegistrator.BLOCK_ENTITY_TAGS_PROVIDER, tags);
    }

    @SafeVarargs
    public final BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> removeTag(Tag.Named<BlockEntityType<?>> ... tags) {
        return (BlockEntityBuilder)this.removeTag(AbstractRegistrator.BLOCK_ENTITY_TAGS_PROVIDER, tags);
    }
}

