/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.tags.Tag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.ItemEntry;
import xyz.apex.forge.utility.registrator.factory.item.ItemFactory;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateItemModelProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.util.NonNullLazyValue;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class ItemBuilder<OWNER extends AbstractRegistrator<OWNER>, ITEM extends Item, PARENT>
extends RegistratorBuilder<OWNER, Item, ITEM, PARENT, ItemBuilder<OWNER, ITEM, PARENT>, ItemEntry<ITEM>> {
    private final ItemFactory<ITEM> itemFactory;
    private NonnullSupplier<Item.Properties> initialProperties = Item.Properties::new;
    private NonnullUnaryOperator<Item.Properties> propertiesModifier = NonnullUnaryOperator.identity();
    @Nullable
    private NonnullSupplier<NonnullSupplier<ItemColor>> colorHandler;

    public ItemBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, ItemFactory<ITEM> itemFactory) {
        super(owner, parent, registryName, callback, Item.class, ItemEntry::new, ItemEntry::cast);
        this.itemFactory = itemFactory;
        this.onRegister(this::onRegister);
        this.defaultModel().defaultLang();
        NonNullLazyValue currentGroup = (NonNullLazyValue)ObfuscationReflectionHelper.getPrivateValue(AbstractRegistrate.class, (Object)((AbstractRegistrator)owner).backend, (String)"currentGroup");
        if (currentGroup != null) {
            this.tab(currentGroup::m_13971_);
        }
    }

    private void onRegister(ITEM item) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(ColorHandlerEvent.Item.class, event -> this.registerItemColor((ColorHandlerEvent.Item)event, item)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColor(ColorHandlerEvent.Item event, ITEM item) {
        if (this.colorHandler != null) {
            event.getItemColors().m_92689_(this.colorHandler.get().get(), new ItemLike[]{item});
        }
    }

    @Override
    @NonnullType
    protected ITEM createEntry() {
        Item.Properties properties = this.initialProperties.get();
        properties = (Item.Properties)this.propertiesModifier.apply(properties);
        return this.itemFactory.create(properties);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> properties(NonnullUnaryOperator<Item.Properties> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> food(FoodProperties food) {
        return this.properties(properties -> properties.m_41489_(food));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> stacksTo(int stackSize) {
        return this.properties(properties -> properties.m_41487_(Math.max(stackSize, 1)));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> defaultDurability(int durability) {
        return this.properties(properties -> properties.m_41499_(durability));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> durability(int durability) {
        return this.properties(properties -> properties.m_41503_(durability));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> craftRemainder(NonnullSupplier<Item> item) {
        return this.properties(properties -> properties.m_41495_((Item)item.get()));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> tab(NonnullSupplier<CreativeModeTab> itemGroup) {
        return this.properties(properties -> properties.m_41491_((CreativeModeTab)itemGroup.get()));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> rarity(Rarity rarity) {
        return this.properties(properties -> properties.m_41497_(rarity));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> fireResistant() {
        return this.properties(Item.Properties::m_41486_);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> noRepair() {
        return this.properties(Item.Properties::setNoRepair);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> initialProperties(NonnullSupplier<Item.Properties> initialProperties) {
        this.initialProperties = initialProperties;
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> color(NonnullSupplier<NonnullSupplier<ItemColor>> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public ItemBuilder<OWNER, ITEM, PARENT> defaultModel() {
        return this.model((ctx, provider) -> provider.generated((NonNullSupplier<? extends ItemLike>)ctx));
    }

    public ItemBuilder<OWNER, ITEM, PARENT> model(NonnullBiConsumer<DataGenContext<Item, ITEM>, RegistrateItemModelProvider> consumer) {
        return (ItemBuilder)this.setDataGenerator(ProviderType.ITEM_MODEL, consumer);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> defaultLang() {
        return (ItemBuilder)this.lang(Item::m_5524_);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> lang(String name) {
        return (ItemBuilder)this.lang(Item::m_5524_, name);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> recipe(NonnullBiConsumer<DataGenContext<Item, ITEM>, RegistrateRecipeProvider> consumer) {
        return (ItemBuilder)this.setDataGenerator(ProviderType.RECIPE, consumer);
    }

    @SafeVarargs
    public final ItemBuilder<OWNER, ITEM, PARENT> tag(Tag.Named<Item> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @SafeVarargs
    public final ItemBuilder<OWNER, ITEM, PARENT> removeTag(Tag.Named<Item> ... tags) {
        return (ItemBuilder)this.removeTags(ProviderType.ITEM_TAGS, tags);
    }

    public ItemBuilder<OWNER, ITEM, PARENT> lang(String languageKey, String localizedValue) {
        return (ItemBuilder)this.lang(languageKey, Item::m_5524_, localizedValue);
    }
}

