/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DistExecutor;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.MenuEntry;
import xyz.apex.forge.utility.registrator.factory.MenuFactory;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;

public final class MenuBuilder<OWNER extends AbstractRegistrator<OWNER>, MENU extends AbstractContainerMenu, SCREEN extends Screen, PARENT>
extends RegistratorBuilder<OWNER, MenuType<?>, MenuType<MENU>, PARENT, MenuBuilder<OWNER, MENU, SCREEN, PARENT>, MenuEntry<MENU>> {
    private final MenuFactory<MENU> menuFactory;
    @Nullable
    private final NonnullSupplier<MenuFactory.ScreenFactory<MENU, SCREEN>> screenFactory;

    public MenuBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, MenuFactory<MENU> menuFactory, @Nullable NonnullSupplier<MenuFactory.ScreenFactory<MENU, SCREEN>> screenFactory) {
        super(owner, parent, registryName, callback, MenuType.class, MenuEntry::new, MenuEntry::cast);
        this.menuFactory = menuFactory;
        this.screenFactory = screenFactory;
        this.onRegister(this::registerScreenFactory);
    }

    private void registerScreenFactory(MenuType<MENU> containerType) {
        if (this.screenFactory != null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MenuScreens.m_96206_((MenuType)containerType, this.screenFactory.get()::create));
        }
    }

    @Override
    protected MenuType<MENU> createEntry() {
        NonNullSupplier supplier = this.asSupplier();
        return IForgeContainerType.create((windowId, playerInventory, buffer) -> this.menuFactory.create((MenuType)supplier.get(), windowId, playerInventory, buffer));
    }
}

