/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.PointOfInterestEntry;
import xyz.apex.java.utility.nullness.NonnullBiPredicate;
import xyz.apex.java.utility.nullness.NonnullPredicate;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class PointOfInterestBuilder<OWNER extends AbstractRegistrator<OWNER>, PARENT>
extends RegistratorBuilder<OWNER, PoiType, PoiType, PARENT, PointOfInterestBuilder<OWNER, PARENT>, PointOfInterestEntry> {
    private NonnullSupplier<? extends Block> block = () -> Blocks.f_50016_;
    private int maxTickets = 1;
    private Predicate predicate = (testType, thisType) -> testType == thisType;
    private int validRange = 1;

    public PointOfInterestBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback) {
        super(owner, parent, registryName, callback, PoiType.class, PointOfInterestEntry::new, PointOfInterestEntry::cast);
    }

    public PointOfInterestBuilder<OWNER, PARENT> matchingBlock(NonnullSupplier<? extends Block> block) {
        this.block = block;
        return this;
    }

    public PointOfInterestBuilder<OWNER, PARENT> maxTickets(int maxTickets) {
        this.maxTickets = maxTickets;
        return this;
    }

    public PointOfInterestBuilder<OWNER, PARENT> predicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public PointOfInterestBuilder<OWNER, PARENT> validRange(int validRange) {
        this.validRange = validRange;
        return this;
    }

    @Override
    @NonnullType
    protected PoiType createEntry() {
        AtomicReference<PoiType> result = new AtomicReference<PoiType>();
        NonnullPredicate<PoiType> predicate = poiType -> (Boolean)this.predicate.apply(poiType, (PoiType)result.get());
        Set matchingBlockStates = PoiType.m_27372_((Block)this.block.get());
        String registryName = this.getRegistryNameFull();
        PoiType poiType2 = new PoiType(registryName, matchingBlockStates, this.maxTickets, predicate, this.validRange);
        result.set(poiType2);
        return poiType2;
    }

    @FunctionalInterface
    public static interface Predicate
    extends NonnullBiPredicate<PoiType, PoiType> {
        @Override
        public boolean test(PoiType var1, PoiType var2);
    }
}

