/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.PointOfInterestBuilder;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.builder.SoundBuilder;
import xyz.apex.forge.utility.registrator.entry.VillagerProfessionEntry;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullType;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;

public final class VillagerProfessionBuilder<OWNER extends AbstractRegistrator<OWNER>, PARENT>
extends RegistratorBuilder<OWNER, VillagerProfession, VillagerProfession, PARENT, VillagerProfessionBuilder<OWNER, PARENT>, VillagerProfessionEntry> {
    private final Set<NonnullSupplier<? extends Item>> requestedItems = Sets.newHashSet();
    private final Set<NonnullSupplier<? extends Block>> secondaryPoi = Sets.newHashSet();
    private Supplier<SoundEvent> workSound = () -> null;
    private NonnullSupplier<PoiType> poiType = () -> PoiType.f_27331_;
    private NonnullBiConsumer<VillagerProfession, VillagerTradesRegistrar> villagerTradesConsumer = NonnullBiConsumer.noop();
    private NonnullBiConsumer<VillagerProfession, WandererTradesRegistrar> wandererTradesConsumer = NonnullBiConsumer.noop();
    @Nullable
    private PointOfInterestBuilder<OWNER, VillagerProfessionBuilder<OWNER, PARENT>> pointOfInterestBuilder = null;

    public VillagerProfessionBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback) {
        super(owner, parent, registryName, callback, VillagerProfession.class, VillagerProfessionEntry::new, VillagerProfessionEntry::cast);
        this.onRegister(this::onRegister);
    }

    private void onRegister(VillagerProfession profession) {
        VillagerTradesRegistrar villagerTrades = new VillagerTradesRegistrar(profession);
        WandererTradesRegistrar wandererTrades = new WandererTradesRegistrar(profession);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, false, VillagerTradesEvent.class, event -> villagerTrades.onEvent((VillagerTradesEvent)event, this.villagerTradesConsumer));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, false, WandererTradesEvent.class, event -> wandererTrades.onEvent((WandererTradesEvent)event, this.wandererTradesConsumer));
    }

    @Override
    @NonnullType
    protected VillagerProfession createEntry() {
        if (this.pointOfInterestBuilder != null) {
            this.copyMappingsTo(this.pointOfInterestBuilder);
        }
        String registryName = this.getRegistryNameFull();
        PoiType pointOfInterestType = this.poiType.get();
        ImmutableSet requestedItems = (ImmutableSet)this.requestedItems.stream().map(NonnullSupplier::get).collect(ImmutableSet.toImmutableSet());
        ImmutableSet secondaryPoi = (ImmutableSet)this.secondaryPoi.stream().map(NonnullSupplier::get).collect(ImmutableSet.toImmutableSet());
        SoundEvent workSound = this.workSound.get();
        return new VillagerProfession(registryName, pointOfInterestType, requestedItems, secondaryPoi, workSound);
    }

    public VillagerProfessionBuilder<OWNER, PARENT> pointOfInterestType(NonnullSupplier<PoiType> poiType) {
        this.poiType = poiType;
        return this;
    }

    public PointOfInterestBuilder<OWNER, VillagerProfessionBuilder<OWNER, PARENT>> poi() {
        if (this.pointOfInterestBuilder == null) {
            this.pointOfInterestBuilder = this.owner.pointOfInterest(this.getName(), this);
            this.poiType = () -> (PoiType)this.pointOfInterestBuilder.asSupplier().get();
        }
        return this.pointOfInterestBuilder;
    }

    public VillagerProfessionBuilder<OWNER, PARENT> secondaryPoi(NonnullSupplier<? extends Block> secondaryPoi) {
        this.secondaryPoi.add(secondaryPoi);
        return this;
    }

    @SafeVarargs
    public final VillagerProfessionBuilder<OWNER, PARENT> secondaryPois(NonnullSupplier<? extends Block> ... secondaryPois) {
        Collections.addAll(this.secondaryPoi, secondaryPois);
        return this;
    }

    public VillagerProfessionBuilder<OWNER, PARENT> requestItem(NonnullSupplier<? extends Item> item) {
        this.requestedItems.add(item);
        return this;
    }

    @SafeVarargs
    public final VillagerProfessionBuilder<OWNER, PARENT> requestItems(NonnullSupplier<? extends Item> ... items) {
        Collections.addAll(this.requestedItems, items);
        return this;
    }

    public VillagerProfessionBuilder<OWNER, PARENT> villagerTrades(NonnullBiConsumer<VillagerProfession, VillagerTradesRegistrar> villagerTradesConsumer) {
        this.villagerTradesConsumer = villagerTradesConsumer;
        return this;
    }

    public VillagerProfessionBuilder<OWNER, PARENT> wandererTrades(NonnullBiConsumer<VillagerProfession, WandererTradesRegistrar> wandererTradesConsumer) {
        this.wandererTradesConsumer = wandererTradesConsumer;
        return this;
    }

    public VillagerProfessionBuilder<OWNER, PARENT> workSound(NonnullSupplier<SoundEvent> workSound) {
        this.workSound = workSound;
        return this;
    }

    public SoundBuilder<OWNER, VillagerProfessionBuilder<OWNER, PARENT>> workSound(String soundName) {
        SoundBuilder sound = this.owner.sound(soundName, this);
        this.workSound = sound.asSupplier();
        return sound;
    }

    private String getTranslationKey() {
        return EntityType.f_20492_.m_20675_() + "." + this.owner.getModId() + "." + this.getName();
    }

    public VillagerProfessionBuilder<OWNER, PARENT> defaultLang() {
        return (VillagerProfessionBuilder)this.lang(profession -> this.getTranslationKey());
    }

    public VillagerProfessionBuilder<OWNER, PARENT> lang(String name) {
        return (VillagerProfessionBuilder)this.lang(profession -> this.getTranslationKey(), name);
    }

    public VillagerProfessionBuilder<OWNER, PARENT> lang(String languageKey, String localizedValue) {
        return (VillagerProfessionBuilder)this.lang(languageKey, profession -> this.getTranslationKey(), localizedValue);
    }

    public static final class VillagerTradesRegistrar {
        private final Map<TradeLevel, Set<VillagerTrades.ItemListing>> tradeMap = Maps.newEnumMap(TradeLevel.class);
        private final VillagerProfession profession;

        private VillagerTradesRegistrar(VillagerProfession profession) {
            this.profession = profession;
        }

        void onEvent(VillagerTradesEvent event, NonnullBiConsumer<VillagerProfession, VillagerTradesRegistrar> consumer) {
            if (event.getType() == this.profession) {
                consumer.accept(this.profession, this);
                if (!this.tradeMap.isEmpty()) {
                    Int2ObjectMap trades = event.getTrades();
                    this.tradeMap.forEach((key, value) -> trades.put(key.getLevel(), (Object)ImmutableList.copyOf((Collection)value)));
                    this.tradeMap.clear();
                }
            }
        }

        public VillagerTradesRegistrar register(TradeLevel level, VillagerTrades.ItemListing trade) {
            this.tradeMap.computeIfAbsent(level, $ -> Sets.newHashSet()).add(trade);
            return this;
        }

        public VillagerTradesRegistrar register(TradeLevel level, VillagerTrades.ItemListing ... trades) {
            Set tradeSet = this.tradeMap.computeIfAbsent(level, $ -> Sets.newHashSet());
            Collections.addAll(tradeSet, trades);
            return this;
        }

        public VillagerTradesRegistrar register(TradeLevel level, Collection<VillagerTrades.ItemListing> trades) {
            this.tradeMap.computeIfAbsent(level, $ -> Sets.newHashSet()).addAll(trades);
            return this;
        }

        public VillagerTradesRegistrar one(VillagerTrades.ItemListing trade) {
            return this.register(TradeLevel.ONE, trade);
        }

        public VillagerTradesRegistrar one(VillagerTrades.ItemListing ... trades) {
            return this.register(TradeLevel.ONE, trades);
        }

        public VillagerTradesRegistrar one(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(TradeLevel.ONE, trades);
        }

        public VillagerTradesRegistrar two(VillagerTrades.ItemListing trade) {
            return this.register(TradeLevel.TWO, trade);
        }

        public VillagerTradesRegistrar two(VillagerTrades.ItemListing ... trades) {
            return this.register(TradeLevel.TWO, trades);
        }

        public VillagerTradesRegistrar two(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(TradeLevel.TWO, trades);
        }

        public VillagerTradesRegistrar three(VillagerTrades.ItemListing trade) {
            return this.register(TradeLevel.THREE, trade);
        }

        public VillagerTradesRegistrar three(VillagerTrades.ItemListing ... trades) {
            return this.register(TradeLevel.THREE, trades);
        }

        public VillagerTradesRegistrar three(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(TradeLevel.THREE, trades);
        }

        public VillagerTradesRegistrar four(VillagerTrades.ItemListing trade) {
            return this.register(TradeLevel.FOUR, trade);
        }

        public VillagerTradesRegistrar four(VillagerTrades.ItemListing ... trades) {
            return this.register(TradeLevel.FOUR, trades);
        }

        public VillagerTradesRegistrar four(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(TradeLevel.FOUR, trades);
        }

        public VillagerTradesRegistrar five(VillagerTrades.ItemListing trade) {
            return this.register(TradeLevel.FIVE, trade);
        }

        public VillagerTradesRegistrar five(VillagerTrades.ItemListing ... trades) {
            return this.register(TradeLevel.FIVE, trades);
        }

        public VillagerTradesRegistrar five(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(TradeLevel.FIVE, trades);
        }
    }

    public static final class WandererTradesRegistrar {
        private final Set<VillagerTrades.ItemListing> genericTrades = Sets.newHashSet();
        private final Set<VillagerTrades.ItemListing> rareTrades = Sets.newHashSet();
        private final VillagerProfession profession;

        private WandererTradesRegistrar(VillagerProfession profession) {
            this.profession = profession;
        }

        void onEvent(WandererTradesEvent event, NonnullBiConsumer<VillagerProfession, WandererTradesRegistrar> consumer) {
            consumer.accept(this.profession, this);
            if (!this.genericTrades.isEmpty()) {
                event.getGenericTrades().addAll(this.genericTrades);
                this.genericTrades.clear();
            }
            if (!this.rareTrades.isEmpty()) {
                event.getRareTrades().addAll(this.rareTrades);
                this.rareTrades.clear();
            }
        }

        public WandererTradesRegistrar register(boolean rare, VillagerTrades.ItemListing trade) {
            (rare ? this.rareTrades : this.genericTrades).add(trade);
            return this;
        }

        public WandererTradesRegistrar register(boolean rare, VillagerTrades.ItemListing ... trades) {
            Collections.addAll(rare ? this.rareTrades : this.genericTrades, trades);
            return this;
        }

        public WandererTradesRegistrar register(boolean rare, Collection<VillagerTrades.ItemListing> trades) {
            (rare ? this.rareTrades : this.genericTrades).addAll(trades);
            return this;
        }

        public WandererTradesRegistrar generic(VillagerTrades.ItemListing trade) {
            return this.register(false, trade);
        }

        public WandererTradesRegistrar generic(VillagerTrades.ItemListing ... trades) {
            return this.register(false, trades);
        }

        public WandererTradesRegistrar generic(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(false, trades);
        }

        public WandererTradesRegistrar rare(VillagerTrades.ItemListing trade) {
            return this.register(true, trade);
        }

        public WandererTradesRegistrar rare(VillagerTrades.ItemListing ... trades) {
            return this.register(true, trades);
        }

        public WandererTradesRegistrar rare(Collection<VillagerTrades.ItemListing> trades) {
            return this.register(true, trades);
        }
    }

    public static enum TradeLevel {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE;

        public static final TradeLevel[] LEVELS;

        public int getLevel() {
            return this.ordinal() + 1;
        }

        public static TradeLevel from(int level) {
            return level <= 5 && level >= 0 ? LEVELS[level] : ONE;
        }

        static {
            LEVELS = TradeLevel.values();
        }
    }
}

