/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.Validate;
import xyz.apex.java.utility.Lazy;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class ArmorMaterial
implements net.minecraft.world.item.ArmorMaterial {
    public static final int[] HEALTH_PER_SLOT = ArmorMaterials.f_40460_;
    public static final EquipmentSlot[] ARMOR_SLOT_TYPES = (EquipmentSlot[])Arrays.stream(EquipmentSlot.values()).filter(slotType -> slotType.m_20743_() == EquipmentSlot.Type.ARMOR).toArray(EquipmentSlot[]::new);
    public final ResourceLocation name;
    public final int durabilityMultiplier;
    public final int[] slotProtections;
    public final int enchantmentValue;
    public final Lazy<SoundEvent> sound;
    public final float toughness;
    public final float knockbackResistance;
    public final Lazy<Ingredient> repairIngredient;

    public ArmorMaterial(ResourceLocation name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, NonnullSupplier<SoundEvent> sound, float toughness, float knockbackResistance, NonnullSupplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = Lazy.of(sound, true);
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = Lazy.of(repairIngredient, true);
    }

    private ArmorMaterial(Builder builder) {
        this.name = builder.name;
        this.durabilityMultiplier = builder.durabilityMultiplier;
        this.enchantmentValue = builder.enchantmentValue;
        this.toughness = builder.toughness;
        this.knockbackResistance = builder.knockbackResistance;
        this.sound = Lazy.of(builder.sound, true);
        this.repairIngredient = Lazy.of(builder.repairIngredient, true);
        this.slotProtections = builder.slotDefenseMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((EquipmentSlot)entry.getKey()).m_20749_())).mapToInt(Map.Entry::getValue).toArray();
    }

    public int m_7366_(EquipmentSlot slotType) {
        return HEALTH_PER_SLOT[slotType.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot slotType) {
        return this.slotProtections[slotType.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound.get();
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public String m_6082_() {
        return this.name.toString();
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Object object = o;
        if (object instanceof ArmorMaterial) {
            ArmorMaterial material = (ArmorMaterial)object;
            return this.durabilityMultiplier == material.durabilityMultiplier && this.enchantmentValue == material.enchantmentValue && Float.compare(material.toughness, this.toughness) == 0 && Float.compare(material.knockbackResistance, this.knockbackResistance) == 0 && Objects.equal((Object)this.name, (Object)material.name) && Objects.equal((Object)this.slotProtections, (Object)material.slotProtections) && Objects.equal(this.sound, material.sound) && Objects.equal(this.repairIngredient, material.repairIngredient);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.durabilityMultiplier, this.slotProtections, this.enchantmentValue, this.sound, Float.valueOf(this.toughness), Float.valueOf(this.knockbackResistance), this.repairIngredient});
    }

    public String toString() {
        return "ArmorMaterial{name=%s, durabilityMultiplier=%d, slotProtections=%s, enchantmentValue=%d, sound=%s, toughness=%s, knockbackResistance=%s, repairIngredient=%s}".formatted(this.name, this.durabilityMultiplier, Arrays.toString(this.slotProtections), this.enchantmentValue, this.sound, Float.valueOf(this.toughness), Float.valueOf(this.knockbackResistance), this.repairIngredient);
    }

    public static Builder builder(ResourceLocation name) {
        return new Builder(name);
    }

    public static Builder builder(String namespace, String name) {
        return ArmorMaterial.builder(new ResourceLocation(namespace, name));
    }

    public static Builder copy(ResourceLocation name, ArmorMaterial armorMaterial) {
        return ArmorMaterial.builder(name).copy(armorMaterial);
    }

    public static Builder copy(String namespace, String name, ArmorMaterial armorMaterial) {
        return ArmorMaterial.copy(new ResourceLocation(namespace, name), armorMaterial);
    }

    public static int getDurabilityMultiplierForSlot(ArmorMaterial armorMaterial, EquipmentSlot slotType) {
        return armorMaterial.m_7366_(slotType) / HEALTH_PER_SLOT[slotType.m_20749_()];
    }

    public static final class Builder {
        private final Map<EquipmentSlot, Integer> slotDefenseMap = Maps.newEnumMap(EquipmentSlot.class);
        private final ResourceLocation name;
        private int durabilityMultiplier = -1;
        private int enchantmentValue = -1;
        private NonnullSupplier<SoundEvent> sound = () -> SoundEvents.f_11675_;
        private float toughness = -1.0f;
        private float knockbackResistance = -1.0f;
        private NonnullSupplier<Ingredient> repairIngredient = () -> Ingredient.f_43901_;

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder copy(Builder builder) {
            this.slotDefenseMap.clear();
            this.slotDefenseMap.putAll(builder.slotDefenseMap);
            return this.durabilityMultiplier(builder.durabilityMultiplier).enchantmentValue(builder.enchantmentValue).sound(builder.sound).toughness(builder.toughness).knockbackResistance(builder.knockbackResistance).repairIngredient(builder.repairIngredient);
        }

        public Builder copy(ArmorMaterial armorMaterial) {
            this.slotDefenseMap.clear();
            Arrays.stream(ARMOR_SLOT_TYPES).forEach(slotType -> this.defenseForSlot((EquipmentSlot)slotType, armorMaterial.m_7365_((EquipmentSlot)slotType)));
            int durabilityMultiplier = Arrays.stream(ARMOR_SLOT_TYPES).mapToInt(slotType -> ArmorMaterial.getDurabilityMultiplierForSlot(armorMaterial, slotType)).max().orElse(0);
            return this.durabilityMultiplier(durabilityMultiplier).enchantmentValue(armorMaterial.m_6646_()).sound(armorMaterial::m_7344_).toughness(armorMaterial.m_6651_()).knockbackResistance(armorMaterial.m_6649_()).repairIngredient(armorMaterial::m_6230_);
        }

        public Builder defenseForSlot(EquipmentSlot slotType, int slotDefense) {
            Validate.isTrue((slotType.m_20743_() == EquipmentSlot.Type.ARMOR ? 1 : 0) != 0);
            this.slotDefenseMap.put(slotType, slotDefense);
            return this;
        }

        public Builder durabilityMultiplier(int durabilityMultiplier) {
            this.durabilityMultiplier = durabilityMultiplier;
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder sound(NonnullSupplier<SoundEvent> sound) {
            this.sound = sound;
            return this;
        }

        public Builder toughness(float toughness) {
            this.toughness = toughness;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder repairIngredient(NonnullSupplier<Ingredient> repairIngredient) {
            this.repairIngredient = repairIngredient;
            return this;
        }

        public Builder repairIngredient(Tag<Item> repairIngredient) {
            return this.repairIngredient(() -> Ingredient.m_43911_((Tag)repairIngredient));
        }

        public Builder repairIngredient(ItemLike ... repairIngredients) {
            return this.repairIngredient(() -> Ingredient.m_43929_((ItemLike[])repairIngredients));
        }

        public ArmorMaterial build() {
            return new ArmorMaterial(this);
        }
    }
}

