/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.helper;

import com.google.common.base.Objects;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xyz.apex.java.utility.Lazy;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class ItemTier
implements Tier {
    public final int level;
    public final int uses;
    public final float speed;
    public final float damage;
    public final int enchantmentValue;
    public final Lazy<Ingredient> repairIngredient;

    public ItemTier(int level, int uses, float speed, float damage, int enchantmentValue, NonnullSupplier<Ingredient> repairIngredient) {
        this.level = level;
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = Lazy.of(repairIngredient, true);
    }

    private ItemTier(Builder builder) {
        this.level = builder.level;
        this.uses = builder.uses;
        this.speed = builder.speed;
        this.damage = builder.damage;
        this.enchantmentValue = builder.enchantmentValue;
        this.repairIngredient = Lazy.of(builder.repairIngredient, true);
    }

    public int m_6609_() {
        return this.uses;
    }

    public float m_6624_() {
        return this.speed;
    }

    public float m_6631_() {
        return this.damage;
    }

    public int m_6604_() {
        return this.level;
    }

    public int m_6601_() {
        return this.enchantmentValue;
    }

    public Ingredient m_6282_() {
        return this.repairIngredient.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Object object = o;
        if (object instanceof ItemTier) {
            ItemTier itemTier = (ItemTier)object;
            return this.level == itemTier.level && this.uses == itemTier.uses && Float.compare(itemTier.speed, this.speed) == 0 && Float.compare(itemTier.damage, this.damage) == 0 && this.enchantmentValue == itemTier.enchantmentValue && Objects.equal(this.repairIngredient, itemTier.repairIngredient);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.level, this.uses, Float.valueOf(this.speed), Float.valueOf(this.damage), this.enchantmentValue, this.repairIngredient});
    }

    public String toString() {
        return "ItemTier{level=%d, uses=%d, speed=%s, damage=%s, enchantmentValue=%d, repairIngredient=%s}".formatted(this.level, this.uses, Float.valueOf(this.speed), Float.valueOf(this.damage), this.enchantmentValue, this.repairIngredient);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(Tier itemTier) {
        return ItemTier.builder().copy(itemTier);
    }

    public static final class Builder {
        private int level = 0;
        private int uses = 1;
        private float speed = 1.0f;
        private float damage = 0.0f;
        private int enchantmentValue = 0;
        private NonnullSupplier<Ingredient> repairIngredient = () -> Ingredient.f_43901_;

        private Builder() {
        }

        public Builder copy(Builder builder) {
            return this.level(builder.level).uses(builder.uses).speed(builder.speed).damage(builder.damage).enchantmentValue(builder.enchantmentValue).repairIngredient(builder.repairIngredient);
        }

        public Builder copy(Tier itemTier) {
            return this.level(itemTier.m_6604_()).uses(itemTier.m_6609_()).speed(itemTier.m_6624_()).damage(itemTier.m_6631_()).enchantmentValue(itemTier.m_6601_()).repairIngredient(() -> ((Tier)itemTier).m_6282_());
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder uses(int uses) {
            this.uses = uses;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder damage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder enchantmentValue(int enchantmentValue) {
            this.enchantmentValue = enchantmentValue;
            return this;
        }

        public Builder repairIngredient(NonnullSupplier<Ingredient> repairIngredient) {
            this.repairIngredient = repairIngredient;
            return this;
        }

        public Builder repairIngredient(Tag<Item> repairIngredient) {
            return this.repairIngredient(() -> Ingredient.m_43911_((Tag)repairIngredient));
        }

        public Builder repairIngredient(ItemLike ... repairIngredients) {
            return this.repairIngredient(() -> Ingredient.m_43929_((ItemLike[])repairIngredients));
        }

        public ItemTier build() {
            return new ItemTier(this);
        }
    }
}

