/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;

public final class BlockListReporter
implements DataProvider {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrator<?> registrator;
    private final DataGenerator generator;

    public BlockListReporter(AbstractRegistrator<?> registrator, DataGenerator generator) {
        this.registrator = registrator;
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_().resolve(Paths.get("reports", this.registrator.getModId(), "blocks.json"));
        JsonObject json = this.serializeBlocks();
        DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)json, (Path)path);
    }

    public String m_6055_() {
        return "Block List: " + this.registrator.getModId();
    }

    private Iterable<Block> getBlocks() {
        return (Iterable)this.registrator.getAll(Block.class).stream().filter(RegistryEntry::isPresent).sorted((a, b) -> a.getId().compareNamespaced(b.getId())).distinct().map(RegistryEntry::get).collect(ImmutableList.toImmutableList());
    }

    private JsonObject serializeBlocks() {
        JsonObject json = new JsonObject();
        this.getBlocks().forEach(block -> json.add(Objects.requireNonNull(block.getRegistryName()).toString(), (JsonElement)this.serializeBlock((Block)block)));
        return json;
    }

    private JsonObject serializeBlock(Block block) {
        JsonObject blockJson = new JsonObject();
        blockJson.add("properties", (JsonElement)this.serializeBlockProperties(block));
        blockJson.add("states", (JsonElement)this.serializeBlockStates(block));
        return blockJson;
    }

    private JsonObject serializeBlockProperties(Block block) {
        JsonObject json = new JsonObject();
        block.m_49965_().m_61092_().forEach(property -> json.add(property.m_61708_(), (JsonElement)this.serializeBlockPropertyPossibleValues((Property<?>)property)));
        return json;
    }

    private JsonArray serializeBlockPropertyPossibleValues(Property<?> property) {
        JsonArray json = new JsonArray();
        property.m_6908_().stream().map(comparable -> Util.m_137453_((Property)property, (Object)comparable)).forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        return json;
    }

    private JsonArray serializeBlockStates(Block block) {
        JsonArray json = new JsonArray();
        block.m_49965_().m_61056_().stream().map(blockState -> this.serializeBlockState(block, (BlockState)blockState)).forEach(arg_0 -> ((JsonArray)json).add(arg_0));
        return json;
    }

    private JsonObject serializeBlockState(Block block, BlockState blockState) {
        JsonObject json = new JsonObject();
        json.add("properties", (JsonElement)this.serializeBlockStateProperties(block, blockState));
        json.addProperty("id", (Number)Block.m_49956_((BlockState)blockState));
        json.addProperty("default", Boolean.valueOf(blockState == block.m_49966_()));
        return json;
    }

    private JsonObject serializeBlockStateProperties(Block block, BlockState blockState) {
        JsonObject json = new JsonObject();
        block.m_49965_().m_61092_().forEach(property -> json.addProperty(property.m_61708_(), Util.m_137453_((Property)property, (Object)blockState.m_61143_(property))));
        return json;
    }
}

