/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.java.utility;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NullableSupplier;

public interface Lazy<T>
extends Supplier<T> {
    @Override
    public T get();

    public void invalidate();

    public static <T> Lazy<T> ofNullable(NullableSupplier<T> supplier, boolean concurrent) {
        return concurrent ? new ConcurrentNullableLazy<T>(supplier) : new NullableLazy<T>(supplier);
    }

    public static <T> Lazy<T> ofNullable(NullableSupplier<T> supplier) {
        return Lazy.ofNullable(supplier, false);
    }

    public static <T> Lazy<T> of(NonnullSupplier<T> supplier, boolean concurrent) {
        return concurrent ? new ConcurrentNonnullLazy<T>(supplier) : new NonnullLazy<T>(supplier);
    }

    public static <T> Lazy<T> of(NonnullSupplier<T> supplier) {
        return Lazy.of(supplier, false);
    }

    public static final class ConcurrentNullableLazy<T>
    implements Lazy<T>,
    NullableSupplier<T> {
        private volatile NullableSupplier<T> supplier;
        @Nullable
        private volatile T instance = null;
        private volatile boolean initialized = false;
        private volatile Object lock = new Object();

        private ConcurrentNullableLazy(NullableSupplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T get() {
            Object localLock = this.lock;
            if (!this.initialized) {
                Object object = localLock;
                synchronized (object) {
                    if (!this.initialized) {
                        this.instance = this.supplier.get();
                        this.initialized = true;
                    }
                }
            }
            return this.instance;
        }

        @Override
        public void invalidate() {
            this.instance = null;
            this.initialized = false;
        }
    }

    public static final class NullableLazy<T>
    implements Lazy<T>,
    NullableSupplier<T> {
        private final NullableSupplier<T> supplier;
        @Nullable
        private T instance = null;
        private boolean initialized = false;

        private NullableLazy(NullableSupplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        @Nullable
        public T get() {
            if (!this.initialized) {
                this.instance = this.supplier.get();
                this.initialized = true;
            }
            return this.instance;
        }

        @Override
        public void invalidate() {
            this.instance = null;
            this.initialized = false;
        }
    }

    public static final class ConcurrentNonnullLazy<T>
    implements Lazy<T>,
    NonnullSupplier<T> {
        private volatile NonnullSupplier<T> supplier;
        @Nullable
        private volatile T instance = null;
        private volatile boolean initialized = false;
        private volatile Object lock = new Object();

        private ConcurrentNonnullLazy(NonnullSupplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Object localLock = this.lock;
            if (!this.initialized) {
                Object object = localLock;
                synchronized (object) {
                    if (!this.initialized) {
                        this.instance = this.supplier.get();
                        this.initialized = true;
                    }
                }
            }
            return Objects.requireNonNull(this.instance);
        }

        @Override
        public void invalidate() {
            this.instance = null;
            this.initialized = false;
        }
    }

    public static final class NonnullLazy<T>
    implements Lazy<T>,
    NonnullSupplier<T> {
        private final NonnullSupplier<T> supplier;
        @Nullable
        private T instance = null;
        private boolean initialized = false;

        private NonnullLazy(NonnullSupplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T get() {
            if (!this.initialized) {
                this.instance = this.supplier.get();
                this.initialized = true;
            }
            return Objects.requireNonNull(this.instance);
        }

        @Override
        public void invalidate() {
            this.instance = null;
            this.initialized = false;
        }
    }
}

