/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.java.utility.nullness;

import java.util.Objects;
import java.util.function.Supplier;
import xyz.apex.java.utility.nullness.NonnullType;

@FunctionalInterface
public interface NonnullSupplier<@NonnullType T>
extends Supplier<T> {
    @Override
    public T get();

    public static <T> NonnullSupplier<T> of(Supplier<T> supplier) {
        return NonnullSupplier.of(supplier, () -> "Unexpected null value from supplier");
    }

    public static <T> NonnullSupplier<T> of(Supplier<T> supplier, NonnullSupplier<String> errorMessage) {
        return () -> Objects.requireNonNull(supplier.get(), errorMessage);
    }
}

