/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.entry.ContainerEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public class ContainerBuilder<T extends AbstractContainerMenu, S extends Screen, P>
extends AbstractBuilder<MenuType<?>, MenuType<T>, P, ContainerBuilder<T, S, P>> {
    private final ForgeContainerFactory<T> factory;
    private final NonNullSupplier<ScreenFactory<T, S>> screenFactory;

    public ContainerBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ContainerFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        this(owner, parent, name, callback, (MenuType<T> type, int windowId, Inventory inv, FriendlyByteBuf $) -> factory.create(type, windowId, inv), screenFactory);
    }

    public ContainerBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ForgeContainerFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        super(owner, parent, name, callback, MenuType.class);
        this.factory = factory;
        this.screenFactory = screenFactory;
    }

    @Override
    @NonnullType
    protected MenuType<T> createEntry() {
        ForgeContainerFactory factory = this.factory;
        NonNullSupplier supplier = this.asSupplier();
        MenuType ret = IForgeContainerType.create((windowId, inv, buf) -> factory.create((MenuType)supplier.get(), windowId, inv, buf));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ScreenFactory screenFactory = this.screenFactory.get();
            MenuScreens.m_96206_((MenuType)ret, (type, inv, displayName) -> screenFactory.create(type, inv, displayName));
        });
        return ret;
    }

    @Override
    protected RegistryEntry<MenuType<T>> createEntryWrapper(RegistryObject<MenuType<T>> delegate) {
        return new ContainerEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ContainerEntry<T> register() {
        return (ContainerEntry)super.register();
    }

    public static interface ContainerFactory<T extends AbstractContainerMenu> {
        public T create(MenuType<T> var1, int var2, Inventory var3);
    }

    public static interface ForgeContainerFactory<T extends AbstractContainerMenu> {
        public T create(MenuType<T> var1, int var2, Inventory var3, @Nullable FriendlyByteBuf var4);
    }

    public static interface ScreenFactory<C extends AbstractContainerMenu, T extends Screen> {
        public T create(C var1, Inventory var2, Component var3);
    }
}

