/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.repack.com.tterrag.registrate.builders;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.RegistryObject;
import xyz.apex.repack.com.tterrag.registrate.AbstractRegistrate;
import xyz.apex.repack.com.tterrag.registrate.builders.AbstractBuilder;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateItemModelProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.entry.ItemEntry;
import xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullFunction;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullSupplier;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonNullUnaryOperator;

public class ItemBuilder<T extends Item, P>
extends AbstractBuilder<Item, T, P, ItemBuilder<T, P>> {
    private final NonNullFunction<Item.Properties, T> factory;
    private NonNullSupplier<Item.Properties> initialProperties = Item.Properties::new;
    private NonNullFunction<Item.Properties, Item.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    @Nullable
    private NonNullSupplier<Supplier<ItemColor>> colorHandler;

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        return ItemBuilder.create(owner, parent, name, callback, factory, null);
    }

    public static <T extends Item, P> ItemBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory, @Nullable NonNullSupplier<? extends CreativeModeTab> group) {
        return new ItemBuilder<T, P>(owner, parent, name, callback, factory).defaultModel().defaultLang().transform(ib -> group == null ? ib : ib.group(group));
    }

    protected ItemBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Item.Properties, T> factory) {
        super(owner, parent, name, callback, Item.class);
        this.factory = factory;
    }

    public ItemBuilder<T, P> properties(NonNullUnaryOperator<Item.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public ItemBuilder<T, P> initialProperties(NonNullSupplier<Item.Properties> properties) {
        this.initialProperties = properties;
        return this;
    }

    public ItemBuilder<T, P> group(NonNullSupplier<? extends CreativeModeTab> group) {
        return this.properties(p -> p.m_41491_((CreativeModeTab)group.get()));
    }

    public ItemBuilder<T, P> color(NonNullSupplier<Supplier<ItemColor>> colorHandler) {
        if (this.colorHandler == null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerItemColor);
        }
        this.colorHandler = colorHandler;
        return this;
    }

    protected void registerItemColor() {
        OneTimeEventReceiver.addModListener(ColorHandlerEvent.Item.class, e -> {
            NonNullSupplier<Supplier<ItemColor>> colorHandler = this.colorHandler;
            if (colorHandler != null) {
                e.getItemColors().m_92689_(colorHandler.get().get(), new ItemLike[]{(ItemLike)this.getEntry()});
            }
        });
    }

    public ItemBuilder<T, P> defaultModel() {
        return this.model((ctx, prov) -> prov.generated(ctx::getEntry));
    }

    public ItemBuilder<T, P> model(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateItemModelProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.ITEM_MODEL, cons);
    }

    public ItemBuilder<T, P> defaultLang() {
        return (ItemBuilder)this.lang(Item::m_5524_);
    }

    public ItemBuilder<T, P> lang(String name) {
        return (ItemBuilder)this.lang(Item::m_5524_, name);
    }

    public ItemBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cons) {
        return (ItemBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    @SafeVarargs
    public final ItemBuilder<T, P> tag(Tag.Named<Item> ... tags) {
        return (ItemBuilder)this.tag(ProviderType.ITEM_TAGS, tags);
    }

    @Override
    protected T createEntry() {
        Item.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Item)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new ItemEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public ItemEntry<T> register() {
        return (ItemEntry)super.register();
    }
}

