/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.block;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.init.PlayerPlushie;
import xyz.apex.forge.apexcore.lib.block.BlockEntityBlock;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;

public final class PlayerPlushieBlock
extends BlockEntityBlock<PlayerPlushieBlockEntity>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE = PlayerPlushieBlock.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)13.0, (double)14.0);
    public static final VoxelShaper SHAPER = VoxelShaper.forHorizontal(SHAPE, Direction.NORTH);

    public PlayerPlushieBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return SHAPER.get(facing);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean waterLogged = fluidState.m_76153_((Tag)FluidTags.f_13131_);
        return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter level, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingBlockState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingBlockState, level, pos, facingPos);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter level, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        SupporterManager.SupporterInfo supporterInfo = PlayerPlushie.getSupporterInfo(stack);
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)((Object)this.getBlockEntity((BlockGetter)level, pos));
        if (blockEntity != null && supporterInfo != null) {
            blockEntity.setSupporterInfo(supporterInfo);
        }
    }

    public void m_49811_(CreativeModeTab itemGroup, NonNullList<ItemStack> stacks) {
        stacks.addAll(PlayerPlushie.getPlushieItems());
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected BlockEntityType<PlayerPlushieBlockEntity> getBlockEntityType() {
        return PlayerPlushie.PLAYER_PLUSHIE_BLOCK_ENTITY.asBlockEntityType();
    }

    public ItemStack getPickBlock(BlockState blockState, HitResult result, BlockGetter level, BlockPos pos, Player player) {
        SupporterManager.SupporterInfo supporterInfo;
        PlayerPlushieBlockEntity blockEntity = (PlayerPlushieBlockEntity)((Object)this.getBlockEntity(level, pos));
        if (blockEntity != null && (supporterInfo = blockEntity.getSupporterInfo()) != null) {
            return PlayerPlushie.getPlushieItem(supporterInfo);
        }
        return super.getPickBlock(blockState, result, level, pos, player);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        SupporterManager.SupporterInfo info = PlayerPlushie.getSupporterInfo(stack);
        if (info != null) {
            String username = info.getUsername();
            BlockGetter blockGetter = level;
            if (blockGetter instanceof Level) {
                Level world = (Level)blockGetter;
                Player player = info.getPlayer(arg_0 -> ((Level)world).m_46003_(arg_0));
                if (player != null) {
                    username = player.m_6302_();
                }
            }
            Object supportLevelName = info.getLevel().m_7912_().toLowerCase(Locale.ROOT);
            String letter = ((String)supportLevelName).substring(0, 1).toUpperCase(Locale.ROOT);
            supportLevelName = letter + ((String)supportLevelName).substring(1);
            tooltip.add((Component)new TextComponent(username).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}).m_130946_(" (").m_7220_((Component)new TextComponent((String)supportLevelName).m_130940_(ChatFormatting.AQUA)).m_130946_(")"));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
        super.m_7926_(builder);
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }
}

